# -*- coding: UTF-8 -*-

from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common

def getValue(context, param):
    '''
    @summary: 获取基地址IP默认值（未被扩容时不涉及）
    '''
    
    try:
        logger = common.getLogger(context.get("logger"), __file__)
        configBaseIpAddr = contextUtil.getItem(context, "configBaseIpAddr")
        
        context["retData"] = ""
        if common.isScaleOutExpansioned(configBaseIpAddr):
            context["retData"] = "#StaticText#%s" % configBaseIpAddr
        else:
            context["retData"] = "172.17.*.1"
            
        contextUtil.handleSuccess(context)
        logger.logPass()
        return
        
    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
     
