# -*- coding: UTF-8 -*-
from cbb.frame.context import contextUtil
from cbb.frame.tlv import adTlvUtil
from cbb.business.operate.expansion import common

#进度总剩余时间
LIMIT_TIME = 30
#进度刷新间隔
INTERVAL = 2

def execute(context):
    '''
    @summary: 修改配置信息
    '''
    node = None
    try:
        #进度条刷新
        common.threadUpProcess(context, LIMIT_TIME, INTERVAL)
        #进度开始
        common.inProcess(context)
        
        logger = common.getLogger(context.get("logger"), __file__)
        tlv = contextUtil.getTlv(context)
        
        lang = contextUtil.getLang(context)
        context["remindInfo"] = common.getDangerNoticeRemindInfo(lang)
        
        enclosureSNbayIdDict = contextUtil.getItem(context, "enclosureSNbayIdDict")
        newConfigCtrlNum = contextUtil.getItem(context, "newConfigCtrlNum")
        baseIpAddr = contextUtil.getItem(context, "baseIpAddr")
        newConfigClustType = contextUtil.getItem(context, "newConfigClustType")
        portsScanList = contextUtil.getItem(context, "portsScanList")
        oldBoardsList = contextUtil.getItem(context, "oldBoardsList")
        newBoardsList = contextUtil.getItem(context, "newBoardsList")
        
        xnetInfo = {}
        xnetInfo["baseIpAddr"] = baseIpAddr
        xnetInfo["newConfigClustType"] = common.getClustType(newConfigClustType)
        xnetInfo["portsScanList"] = portsScanList

        contextUtil.setItem(context, contextUtil.EXP_FLOW_STATUS_KEY, contextUtil.EXP_FLOW_STATUS_CHANGE_DATA)

        for board in newBoardsList:
            node = board
            newBayID = common.getNodeBayId(enclosureSNbayIdDict, board, newBoardsList)
            ctrlNum = newConfigCtrlNum
            adTlvUtil.modifyBayIDCtrlNum(tlv, board, newBayID, ctrlNum)
            logger.logInfo("write bayid and ctrlNum success[newCtrl]:%s" % board)
        
        for board in newBoardsList:
            node = board
            newBayID = common.getNodeBayId(enclosureSNbayIdDict, board, newBoardsList)
            adTlvUtil.modifyXnetInfo(tlv, board, newBayID, xnetInfo)
            logger.logInfo("write xnetInfo success[newCtrl]:%s" % board)
            
        for board in oldBoardsList:
            node = board
            adTlvUtil.modifyCtrlNum(tlv, board, newConfigCtrlNum)
            logger.logInfo("write ctrlNum success[oldCtrl]:%s" % board)
            
        for board in oldBoardsList:
            node = board
            newBayID = common.getNodeBayId(enclosureSNbayIdDict, board, oldBoardsList)
            adTlvUtil.modifyXnetInfo(tlv, board, newBayID, xnetInfo)
            logger.logInfo("write xnetInfo success[oldCtrl]:%s" % board)
            
        contextUtil.handleSuccess(context)
        logger.logPass()
        return
        
    except Exception as exception:
        if node is None:
            contextUtil.handleException(context, exception)
        else:
            lang = contextUtil.getLang(context)
            resultDict = {"flag":False, "errMsg":"", "suggestion":""}
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "modify.config.failure", node["enclosureSN"])
            contextUtil.handleException(context, exception, resultDict)
        logger.logException(exception)
        return
    finally:
        context["remindInfo"] = ""
        #进度条刷为完成状态
        common.finishProcess(context)
