# coding:utf-8
""" 
@version: Toolkit V200R005C00
@time: 2018/05/29 
@file: oneCmdExpandCtrl.py
@function:  扩容流程管理脚本。
@modify: 
"""

# noinspection PyUnresolvedReferences
import com.huawei.ism.tool.bizpack.wizardparse.entity.item.ItemResult as ItemResult

from cbb.business.operate.expansion import common
from cbb.business.operate.expansion.ctrlExpFlowMgr import ExpConstants
from cbb.business.operate.expansion.ctrlExpFlowMgr import ExpFlowMgr
from cbb.frame.context import contextUtil
from cbb.frame.tlv import adTlvUtil
from cbb.business.operate.checkitems import open_failover
from cbb.frame.cli import cliUtil
from cbb.frame.base import baseUtil
from cbb.frame.tlv import tlvUtil


def execute(context):
    """执行扩容控制器命令，并轮询执行结果。

    :param context:
    :return:
    """
    logger = common.getLogger(context.get("logger"), __file__)
    expCtrlFlow = contextUtil.getItem(context, 'expCtrlFlow', None)
    try:
        lang = contextUtil.getLang(context)
        cli = contextUtil.getCli(context)
        context["remindInfo"] = common.getDangerNoticeRemindInfo(lang)
        # 初始化扩容回退标志位
        context["isRollbacking"] = False
        if expCtrlFlow is None:
            logger.logInfo('First time to do expansion ctrl.')
            expCtrlFlow = ExpFlowMgr(context)
            expCtrlFlow.recordFlow()
            expCtrlFlow.setItemResult(0, ItemResult.EXECUTING)  # 第一步初始化为正在执行。
            # 打开SMB连续性开关
            if not smb_result(expCtrlFlow, context, lang, logger, cli):
                return
            errCode = expCtrlFlow.start()
            if errCode != 0:
                logger.logInfo('start ctrl expansion flow failed.')
                expCtrlFlow.setItemResult(0, ItemResult.FAILED)  # 第一步初始化为失败。
                expCtrlFlow.setExpFlowStatus(False, errCode)
                return
            else:
                expCtrlFlow.setItemResult(0, ItemResult.SUCCEED)

        else:  # “重新执行“按钮执行次流程。
            expCtrlFlow.refreshConn(context)
            context["showPowerOnInfo"] = False
            logger.logInfo('Retry expansion ctrl flow.')  # Refresh route info without condition when retrying
            expCtrlFlow.setItemResult(0, ItemResult.EXECUTING, reSetStartTime=True)
            # 打开SMB连续性开关
            if contextUtil.getItem(context, "open_smb_result") == "Failed" and \
                    not smb_result(expCtrlFlow, context, lang, logger, cli):
                return
            # 如果不是高端插入式扩控，重试时需要扫描AD和节点
            if not expCtrlFlow.needInsertCtrl:
                preExecuteExpStep = contextUtil.getItem(context,
                                                        "preExecuteExpStep",
                                                        None)
                logger.logInfo('preExecuteExpStep is : %s' % str(
                    preExecuteExpStep))

                contextUtil.setItem(context, "isADStarted", False)
                resultFlag, errCode = adTlvUtil.restartAD(
                    context,
                    expCtrlFlow.tlv,
                    logger,
                    expCtrlFlow.oldCtrlNum)
                # 如果上一次执行失败在重启控制器、新控上电步骤，
                # 则重试时进行AD扫描并忽略结果
                if preExecuteExpStep in \
                        [ExpConstants.STEP_MAP_REVERSE["RST_NEW_CTRL"],
                         ExpConstants.STEP_MAP_REVERSE["NEW_CTRL_JOIN_SYS"]]:
                    contextUtil.setItem(context, "isADStarted", True)
                else:
                    if not resultFlag:
                        # 第一步初始化为失败。
                        expCtrlFlow.setItemResult(0, ItemResult.FAILED)
                        expCtrlFlow.setExpFlowStatus(False, errorCode=errCode)
                        return

            restErrCode, expErrCode, curCtrlExpStep, ctrlExpFlowState = expCtrlFlow.qrySysCurrentExpFlow()
            if restErrCode == 0 and expCtrlFlow.checkCtrlFlowOver(curCtrlExpStep):  # 重试时有可能已经扩容成功。
                logger.logInfo('Expansion flow may success, return directly.')
                expCtrlFlow.setExpFlowStatus(True)
                return

            if expCtrlFlow.handleFlowRollbacking(curCtrlExpStep, ctrlExpFlowState):  # 扩控流程回滚中，直接退出.
                return

            if ctrlExpFlowState in [ExpConstants.FLOW_STATE_MAP.get('INIT'),
                                    ExpConstants.FLOW_STATE_MAP.get('PAUSED')]:  # 如果当前扩容流程暂停，重新触发扩容。
                logger.logInfo('previous ctrl expansion flow init or paused, restart expansion flow')
                curCtrlExpStep = expCtrlFlow.lastExecutingStep \
                    if expCtrlFlow.lastExecutingStep > curCtrlExpStep else curCtrlExpStep

                errCode = expCtrlFlow.start()
                if errCode != 0:
                    logger.logInfo('Restart ctrl expansion flow failed.')
                    expCtrlFlow.setItemResult(curCtrlExpStep, ItemResult.FAILED)  # 第一步初始化为失败。
                    expCtrlFlow.setExpFlowStatus(False, errorCode=errCode)
                    return
                else:
                    logger.logInfo('Restart ctrl expansion flow success.')
                    expCtrlFlow.setItemResult(0, ItemResult.SUCCEED)

        expCtrlFlow.qryCtrlExpansionFlow()
    except Exception as e:
        logger.logException(e)
        try:
            errCode = int(e.args[0])
        except Exception as ex:
            logger.logException(ex)
            errCode = ExpConstants.COMMON_ERROR_CODE

        handleExpansion(context, errCode, expCtrlFlow, logger)
        return
    except:
        logger.logNoPass('other exception caught.')
        handleExpansion(context, 'OTHER_EXCEPTION', expCtrlFlow, logger)
    finally:
        context["remindInfo"] = ""
        if expCtrlFlow:
            expCtrlFlow.updateUI()


def handleExpansion(context, errCode, expCtrlFlow, logger):
    """处理异常。

    :param context:
    :param errCode:
    :param expCtrlFlow:
    :param logger:
    :return:
    """
    if expCtrlFlow:
        executingStep = contextUtil.getItem(context, 'executingStep', 0)
        expCtrlFlow.setItemResult(executingStep, ItemResult.FAILED)
        expCtrlFlow.setExpFlowStatus(False, errorCode=errCode)
    else:
        errCause, suggest = contextUtil.getItem(context, 'errCodeMgrObj', {}).get(errCode)
        logger.logInfo(u'errmsg:%s, suggest:%s' % (errCause, suggest))
        context["succ"] = False
        context["errMsg"] = errCause
        context["suggestion"] = suggest


def open_smb(context, lang, logger, cli):
    """
    打开SMB业务开关
    :param context:
    :param lang:
    :param logger:
    :param cli:
    :return:
    """
    # 获取设备型号
    flag, product_model, err_msg = cliUtil.getProductModel(cli, lang)
    if not flag:
        err_msg, suggestion = common.getMsg(lang, "system.abnormal")
        return False, err_msg, suggestion
    logger.logInfo('product_model: {}'.format(product_model))
    # 获取原集群控制器个数
    tlv = contextUtil.getTlv(context)
    controller_num = tlvUtil.getControllersNum(tlv)
    logger.logInfo('controller_num: {}'.format(controller_num))
    # 判断是否为内双活，或者单引擎扩控
    has_inner_hyper_metro_license = contextUtil.getItem(
        context, "hasInnerMetroLicense")
    # 判断是否为引擎内扩控
    if has_inner_hyper_metro_license or \
            (baseUtil.isDoradoV6HighEnd(product_model) and controller_num == 2):
        return open_failover.execute(context)
    return True, "", ""


def smb_result(exp_ctrl_flow, context, lang, logger, cli):
    """
    开启SMB结果
    """
    flag, err_msg, suggestion = open_smb(context, lang, logger, cli)
    if not flag:
        exp_ctrl_flow.setItemResult(0, ItemResult.FAILED)
        exp_ctrl_flow.setExpFlowStatus(False, "smb_failed", err_msg=err_msg,
                                       suggestion=suggestion)
        contextUtil.setItem(context, "open_smb_result", "Failed")
        return False
    contextUtil.setItem(context, "open_smb_result", "Success")
    return True
