# -*- coding: UTF-8 -*-

from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common
from cbb.business.operate.expansion import config
from cbb.frame.tlv import adTlvUtil

def saveData(context):
    '''
    @summary: 保存基地址IP
    '''
    
    try:
        logger = common.getLogger(context.get("logger"), __file__)
        lang = contextUtil.getLang(context)
        tlv = contextUtil.getTlv(context)
        
        baseIpAddr = context["input_configBaseIPScaleOut_base_ip_addr"]
        configBaseIpAddr = contextUtil.getItem(context, "configBaseIpAddr")
        boardsList = contextUtil.getItem(context, "boardsList")
        
        #校验是否为合法的基地址IP
        if not common.isScaleOutExpansioned(configBaseIpAddr) and not common.isIllegalBaseIpAddr(baseIpAddr):
            errMsg, suggestion = common.getMsg(lang, "base.addr.invalid", config.BASE_IP_RANGE)
            resultDict = {"flag":False, "errMsg":errMsg, "suggestion":suggestion}
            contextUtil.handleFailure(context, resultDict)
            return
        
        #校验基地址IP是否与管理口、维护口、业务口IP冲突
        for board in boardsList:
            try:
                adTlvUtil.checkBaseIPConflict(tlv, board, baseIpAddr)
            except Exception as exception:
                logger.logException(exception)
                expArgs = exception.args
                if expArgs is not None and len(expArgs) == 2:
                    errCode = str(expArgs[0]).strip()
                    if not common.isScaleOutExpansioned(configBaseIpAddr):
                        if common.IP_CONFLICT_ERRCODE_UNEXPANSIONED_DEFINE.has_key(errCode):
                            errMsg, suggestion = common.getMsg(lang, common.IP_CONFLICT_ERRCODE_UNEXPANSIONED_DEFINE[errCode], board["enclosureSN"])
                            resultDict = {"flag":False, "errMsg":errMsg, "suggestion":suggestion}
                            contextUtil.handleFailure(context, resultDict)
                            return
                    else:
                        if common.IP_CONFLICT_ERRCODE_EXPANSIONED_DEFINE.has_key(errCode):
                            errMsg, suggestion = common.getMsg(lang, common.IP_CONFLICT_ERRCODE_EXPANSIONED_DEFINE[errCode], board["enclosureSN"])
                            resultDict = {"flag":False, "errMsg":errMsg, "suggestion":suggestion}
                            contextUtil.handleFailure(context, resultDict)
                            return
                        else:
                            errMsg, suggestion = common.getMsg(lang, common.IP_CONFLICT_ERRCODE_EXPANSIONED_DEFINE[errCode], board["enclosureSN"])
                            resultDict = {"flag":False, "errMsg":errMsg, "suggestion":suggestion}
                            contextUtil.handleFailure(context, resultDict)
                            return
                        
                errMsg, suggestion = common.getMsg(lang, "confilict.common.info")
                resultDict = {"flag":False, "errMsg":errMsg, "suggestion":suggestion}
                contextUtil.handleFailure(context, resultDict)
                return
                
        contextUtil.setItem(context, "baseIpAddr", baseIpAddr)
        contextUtil.handleSuccess(context)
        logger.logPass()
        return
        
    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
     
