# -*- coding: UTF-8 -*-

from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common
from cbb.business.operate.expansion import config

def saveData(context):
    '''
    @summary: 保存已扩容引擎管理IP
    '''
    
    try:
        logger = common.getLogger(context.get("logger"), __file__)
        lang = contextUtil.getLang(context)
        
        newBayIds = [int(item) for item in set(contextUtil.getItem(context, "newBayIds"))]
        baseIpAddr = contextUtil.getItem(context, "baseIpAddr")
        ipVer = contextUtil.getItem(context, "ipVer")
        

        #只保存一个新引擎的管理IP，其他引擎管理IP不配置
        newBayId = newBayIds[0]
        manIpList = []
        manIpList.append({"bayid":newBayId, "slot":0, 
          "manIp":context["input_configManIPScaleOut_eng%s.ip1" % newBayId],
          "mask":context["input_configManIPScaleOut_eng%s.mask1" % newBayId],
          "gateway":context["input_configManIPScaleOut_eng%s.gateway1" % newBayId]})
        manIpList.append({"bayid":newBayId, "slot":1, 
          "manIp":context["input_configManIPScaleOut_eng%s.ip2" % newBayId],
          "mask":context["input_configManIPScaleOut_eng%s.mask2" % newBayId],
          "gateway":context["input_configManIPScaleOut_eng%s.gateway2" % newBayId]})
        
        allManIps = []    
        for manIpDict in manIpList:
            ctrlIpAddr = manIpDict["manIp"]
            mask = manIpDict["mask"]
            gateway = manIpDict["gateway"]
            allManIps.append(ctrlIpAddr)
            
            if not common.isIllegalManIpAddr(ctrlIpAddr, ipVer):
                errMsg, suggestion = common.getMsg(lang, "ctrl.ip.addr.invalid", (ipVer, manIpDict["slot"] + 1))
                resultDict = {"flag":False, "errMsg":errMsg, "suggestion":suggestion}
                contextUtil.handleFailure(context, resultDict)
                return

            if not common.isIllegalMask(mask, ipVer):
                if ipVer == common.IPV4:
                    errMsg, suggestion = common.getMsg(lang, "ctrl.ip.mask.invalid", (manIpDict["slot"] + 1))
                    resultDict = {"flag":False, "errMsg":errMsg, "suggestion":suggestion}
                    contextUtil.handleFailure(context, resultDict)
                    return
                else:
                    errMsg, suggestion = common.getMsg(lang, "ctrl.ip.prefix.invalid", (manIpDict["slot"] + 1))
                    resultDict = {"flag":False, "errMsg":errMsg, "suggestion":suggestion}
                    contextUtil.handleFailure(context, resultDict)
                    return

            if (gateway is not None and gateway != "") and not common.isIllegalGateway(gateway, ipVer):
                errMsg, suggestion = common.getMsg(lang, "ctrl.ip.gateway.invalid", (manIpDict["slot"] + 1))
                resultDict = {"flag":False, "errMsg":errMsg, "suggestion":suggestion}
                contextUtil.handleFailure(context, resultDict)
                return
            
            baseIpPrefix = ".".join(baseIpAddr.split(".")[0:2]) + "."
            if ctrlIpAddr.startswith(baseIpPrefix):
                errMsg, suggestion = common.getMsg(lang, "ip.address.conflict", (manIpDict["bayid"], manIpDict["slot"] + 1))
                resultDict = {"flag":False, "errMsg":errMsg, "suggestion":suggestion}
                contextUtil.handleFailure(context, resultDict)
                return
        
        if len(allManIps) != len(set(allManIps)):
            errMsg, suggestion = common.getMsg(lang, "eng.ip.conflict")
            resultDict = {"flag":False, "errMsg":errMsg, "suggestion":suggestion}
            contextUtil.handleFailure(context, resultDict)
            return
            
        logger.logInfo("manIpList:%s" % manIpList)
        contextUtil.setItem(context, "manIpList", manIpList)
        contextUtil.handleSuccess(context)
        logger.logPass()
        return
        
    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return

def getItems(context, param):
    try:
        logger = common.getLogger(context.get("logger"), __file__)
        
        ipVer = contextUtil.getItem(context, "ipVer")
        resultList = []
        newBayIds =  [int(item) for item in set(contextUtil.getItem(context, "newBayIds"))]
        logger.logInfo("newBayIds:%s" % newBayIds)
        
        #只配置一个新引擎的管理IP，其他引擎管理IP不配置
        newBayId = newBayIds[0]
            
        idIp1 = "eng%s.ip1" % newBayId
        idIp2 = "eng%s.ip2" % newBayId
        idMask1 = "eng%s.mask1" % newBayId
        idMask2 = "eng%s.mask2" % newBayId
        idGateway1 = "eng%s.gateway1" % newBayId
        idGateway2 = "eng%s.gateway2" % newBayId
        
        labelIp1 = "manIP.eng.%s.ip1" % ipVer
        labelIp2 = "manIP.eng.%s.ip2" % ipVer
        labelMask1 = "manIP.eng.%s.mask1" % ipVer
        labelMask2 = "manIP.eng.%s.mask2" % ipVer
        labelGateway1 = "manIP.eng.%s.gateway1" % ipVer
        labelGateway2 = "manIP.eng.%s.gateway2" % ipVer
            
        ip1 = {"id":idIp1,"type":"text","label":labelIp1,"default":""}
        mask1 = {"id":idMask1,"type":"text","label":labelMask1,"default":""}
        gateway1 = {"id":idGateway1,"type":"text","label":labelGateway1,"default":""}
        ip2 = {"id":idIp2,"type":"text","label":labelIp2,"default":""}
        mask2 = {"id":idMask2,"type":"text","label":labelMask2,"default":""}
        gateway2 = {"id":idGateway2,"type":"text","label":labelGateway2,"default":""}
        resultList.extend([ip1, mask1, gateway1, ip2, mask2, gateway2])
        
        seperators = config.NODE_MAX / 2 - len(newBayIds) * 2
        if seperators > 0:
            sep = {"id":"sep", "type":"%sseperator" % seperators}
            resultList.append(sep)
            
        context["retData"] = common.dictList2JsonArray(resultList)
        contextUtil.handleSuccess(context)
        
        logger.logPass()
        return
        
    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
    return
