# -*- coding: UTF-8 -*-

from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common

def saveData(context, param):
    
    resultDict = {"flag":True, "errMsg":"", "suggestion":""}
    logger = common.getLogger(context.get("logger"), __file__)
    lang = contextUtil.getLang(context)
    
    newConfigCtrlNum = contextUtil.getItem(context, "newConfigCtrlNum")
    ctrlNum = contextUtil.getItem(context, "ctrlNum")
    ctrlHeight = contextUtil.getItem(context, "ctrlHeight")
    
    newExpansionBoardsList = contextUtil.getItem(context, "newExpansionBoardsList")
    scanEnclosuresResult = context["allInput_scanEnclosuresScaleOut_scanEnclosures"]
    beExpansionEnclosuresList = common.getExpansionEnclosuresList(scanEnclosuresResult, lang)
    
    newBoardsList = common.getNewBoardsList(beExpansionEnclosuresList, newExpansionBoardsList)
    newBoardsList.sort(lambda x,y:common.cmpBoard(x,y))
    currentExpansionCtrlsNum = len(newBoardsList)
    requiredExpansionCtrlsNum = newConfigCtrlNum - ctrlNum
    
    logger.logInfo("beExpansionEnclosuresList:%s" % beExpansionEnclosuresList)
    logger.logInfo("newBoardsList:%s" % newBoardsList)
    logger.logInfo("currentExpansionCtrlsNum:%s" % currentExpansionCtrlsNum)
    logger.logInfo("requiredExpansionCtrlsNum:%s" % requiredExpansionCtrlsNum)
    
    if currentExpansionCtrlsNum < requiredExpansionCtrlsNum:
        resultDict["flag"] = False
        resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "select.new.ctrls.less", 
           (currentExpansionCtrlsNum, requiredExpansionCtrlsNum))
        contextUtil.handleFailure(context, resultDict)
        return 
    
    if currentExpansionCtrlsNum > requiredExpansionCtrlsNum:
        resultDict["flag"] = False
        resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "select.new.ctrls.more", 
           (currentExpansionCtrlsNum, requiredExpansionCtrlsNum))                                                     
        contextUtil.handleFailure(context, resultDict)
        return
    
    for enclosureSN in beExpansionEnclosuresList:
        ctrlsNum = common.getEnclosureNodes(enclosureSN, newBoardsList)
        #待扩容引擎上存在单控的情况下不允许进行扩容
        #待扩控只允许为1个引擎（2U和3U场景下，不能超过2控，6U场景下，不能超过4控），如2个4控引擎不能扩容
        if ctrlsNum % 2 != 0 or \
           (ctrlHeight in [2, 3] and ctrlsNum > 2) or \
           (ctrlHeight == 6 and ctrlsNum > 4):
            resultDict["flag"] = False
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "select.new.ctrls.illegal", enclosureSN)
            contextUtil.handleFailure(context, resultDict)
            return
    
    oldBoardsList = contextUtil.getItem(context, "oldBoardsList")
    boardsList = oldBoardsList + newBoardsList
    switchOnBoardsList = newBoardsList
    
    logger.logInfo("boardsList:%s" % boardsList)
    logger.logInfo("switchOnBoardsList:%s" % switchOnBoardsList)
    
    contextUtil.setItem(context, "newBoardsList", newBoardsList)
    contextUtil.setItem(context, "boardsList", boardsList)
    contextUtil.setItem(context, "switchOnBoardsList", switchOnBoardsList)
        
    contextUtil.handleSuccess(context)
    logger.logPass()
    return
    
def initData(context, param):
    '''
    @summary: 显示扫描到待扩容控制器信息
    '''
    
    try:
        
        logger = common.getLogger(context.get("logger"), __file__)
        lang = contextUtil.getLang(context)
        
        yes = common.getRes(lang, "yes")
        no = common.getRes(lang, "no")
        newExpansionBoardsList = contextUtil.getItem(context, "newExpansionBoardsList")
        newExpansionEncolsureSNList = contextUtil.getItem(context, "newExpansionEncolsureSNList")
        
        enclosureSNsScanList = [{
         "beExpansion":"#drop-down#%s,%s#drop-default#%s" % (yes,no,no), 
         "enclosureSN":enclosureSN, 
         "ctrlsNum":common.getEnclosureNodes(enclosureSN, newExpansionBoardsList) 
            } for enclosureSN in newExpansionEncolsureSNList]
        
        context["retData_scanEnclosures"] = common.dictList2JsonArray(enclosureSNsScanList)
        
        contextUtil.handleSuccess(context)
        logger.logPass()
        return
        
    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
    
    return