# -*- coding: UTF-8 -*-
from cbb.frame.context import contextUtil
from cbb.frame.tlv import tlvUtil
from cbb.business.operate.expansion import common

def execute(context):
    '''
    @summary: 清除BMC
    '''
    
    try:
        logger = common.getLogger(context.get("logger"), __file__)
        
        tlv = contextUtil.getTlv(context)
        tlvUtil.deleteBMC(tlv)
        logger.logInfo("BMC deleted")
        contextUtil.handleSuccess(context)
        logger.logPass()
        return
        
    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
