# -*- coding: UTF-8 -*-
from cbb.frame.context import contextUtil
from cbb.frame.tlv import tlvUtil
from cbb.business.operate.expansion import common

#进度总剩余时间
LIMIT_TIME = 30
#进度刷新间隔
INTERVAL = 2

def execute(context):
    '''
    @summary: 修改控制器数量
    '''
    try:
        #进度条刷新
        common.threadUpProcess(context, LIMIT_TIME, INTERVAL)
        #进度开始
        common.inProcess(context)
        
        logger = common.getLogger(context.get("logger"), __file__)
        
        tlv = contextUtil.getTlv(context)
        newConfigCtrlNum = contextUtil.getItem(context, "newConfigCtrlNum")
        if contextUtil.getItem(context, "ctrlNum") == 2:
            newConfigCtrlNum = 4
        try:
            contextUtil.setItem(context, contextUtil.EXP_FLOW_STATUS_KEY, contextUtil.EXP_FLOW_STATUS_CHANGE_DATA)
            tlvUtil.modifyCtrlNum(tlv, newConfigCtrlNum)
        except Exception as exception:
            lang = contextUtil.getLang(context)
            resultDict = {"flag":False, "errMsg":"", "suggestion":""}
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "modify.config.failure.v3")
            contextUtil.handleException(context, exception, resultDict)
            logger.logException(exception)
            return
        
        logger.logInfo("modify ctrl num")
        contextUtil.handleSuccess(context)
        logger.logPass()
        return
        
    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
    finally:
        #进度条刷为完成状态
        common.finishProcess(context)
