# -*- coding: UTF-8 -*-

from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common

def cancel(context):
    '''
    @summary: 扩容中，用户点击取消时按钮时处理
    '''
    
    try:
        logger = common.getLogger(context.get("logger"), __file__)
        lang = contextUtil.getLang(context)
        
        errMsgKey = "expansion.cancel.prompt.pciescaleout"
        
        dangerMsg,suggestion = common.getMsg(lang, errMsgKey)
        context["succ"] = False
        context["errMsg"] = ""
        context["dangerMsg"] = dangerMsg
        context["suggestion"] = suggestion
        return
    
    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
