# -*- coding: UTF-8 -*-

from cbb.business.operate.expansion import common
from cbb.frame.context import contextUtil

def init(context, param):
    
    logger = common.getLogger(context.get("logger"), __file__)
    lang = contextUtil.getLang(context)
    checkItems = []

    checkPowerCable = {
      "id":len(checkItems),
      "name":"checkPowerCable",
      "param":len(checkItems),
      "title":common.getRes(lang, "checkPowerCableTitle"),
      "script":"../../checkCable/checkPowerCable.py",
    }
    checkItems.append(checkPowerCable)
    
    
    checkSASCable = {
      "id":len(checkItems),
      "name":"checkSASCable",
      "param":len(checkItems),
      "title":common.getRes(lang, "checkSASCableTitle"),
      "script":"../../checkCable/checkSASCable.py",
    }
    checkItems.append(checkSASCable)

    checkMgmtCable = {
      "id":len(checkItems),
      "name":"checkMgmtCable",
      "param":len(checkItems),
      "title":common.getRes(lang, "checkMgmtCableTitle"),
      "script":"../../checkCable/checkMgmtCable.py",
    }
    checkItems.append(checkMgmtCable)
 
    newConfigCtrlNum = contextUtil.getItem(context, "newConfigCtrlNum")
    logger.logInfo("newConfigCtrlNum:%s" % newConfigCtrlNum)
    if newConfigCtrlNum > 4:
        checkPCIeCable = {
          "param":len(checkItems),
          "id":len(checkItems),
          "name":"checkPCIeCable",
          "title":common.getRes(lang, "checkPCIeCableTitle"),
          "script":"../../checkCable/checkPCIeCable.py",
        }
        checkItems.append(checkPCIeCable)
    
    contextUtil.setItem(context, "checkItems", checkItems)
    contextUtil.setCableDetectItem(context, checkItems)
    return