# -*- coding: UTF-8 -*-

from cbb.frame.context import contextUtil
from cbb.frame.devGraph import graphUtil
from cbb.business.operate.expansion import common
import time
import threading
from cbb.frame.cli import cliUtil
from cbb.frame.base import baseUtil

ALARM_BLACKLIST=set([
    '0xF00CF0017',      #
])
CHECK_STATE_CHECKING = "checking"
CHECK_STATE_FINISHED = "finished"
CHECK_TIME_INTERVAl = 5

def execute(context):
    '''
    @summary: 检查新集群的控制器数量是否满足要求
    '''
    
    try:
        resultDict = {"flag":True, "errMsg":"", "suggestion":""}
        logger = common.getLogger(context.get("logger"), __file__)
        cli = contextUtil.getCli(context)
        lang = contextUtil.getLang(context)
        context["remindInfo"] = common.getDangerNoticeRemindInfo(lang)
        newConfigCtrlNum = contextUtil.getItem(context, "newConfigCtrlNum")
        context["checkState"] = CHECK_STATE_CHECKING
        
        version = contextUtil.getItem(context, "productVersion")
        powerOnTime = common.getPoweronCtrlTime(version)
        
        #进度条刷新
        t = threading.Thread(target = updateProcess,args=(context,))
        t.start()
        #发现控制器数目
        ret = check18000ClusterCtrlsNumWithDetail(context, cli, lang, newConfigCtrlNum, traceType= "11", timeOut = powerOnTime)
        
        if not ret["flag"]:
            resultDict["flag"] = False
            resultDict["errMsg"], resultDict["suggestion"] = ret["errMsg"], ret["suggestion"]
            context["checkState"] = CHECK_STATE_FINISHED
            contextUtil.handleFailure(context, resultDict)
            return 
        
        #新设备加入后更新设备图
        graphUtil.drawGraph(context, {"isBack":False})
        
        context["checkState"] = CHECK_STATE_FINISHED
        baseUtil.safeSleep(1)

        contextUtil.setItem(context, contextUtil.EXP_FLOW_STATUS_KEY, contextUtil.EXP_FLOW_STATUS_JOIN_SYS_SUCCESS)
        contextUtil.handleSuccess(context)
        logger.logPass()
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
    finally:
        try:
            context["checkState"] = CHECK_STATE_FINISHED
            context["remindInfo"] = ""
            t.join()
        except Exception as exception:
            logger.logException(exception)
        finally:
            context["curRemainTime"] = 0
            common.setExpansionProgress(context, True)

def check18000ClusterCtrlsNumWithDetail(context, cli, lang, requiredCtrlsNum, traceType= "11", timeOut = common.NEW_CLUSTER_CTRLS_NUM_CHECK_TIME_LIMIT, rollbackInfo={"rollback":True}):
    '''
    @summary: 检查新集群的控制器数量是否满足要求
    @param cli: cli对象
    @param lang: 语言lang
    @param requiredCtrlsNum: 新集群需要的控制器数量
    @return: 以字典形式返回结果
        flag:
            True: 检查通过
            False: 检查不通过
        errMsg: 错误消息
        suggestion: 修复建议
    '''
    result = {"flag":True, "errMsg":"", "suggestion":"", "ret":""}
    logger = common.getLogger(context.get("logger"), __file__)
    common.setExpStep(context, requiredCtrlsNum)
    startTime = time.clock()
    isCtrlsNumOK = False
    isTraceFailure = False
    stepFlowList = []
    #用于界面展示的stepFlowList
    stepFlowShowList = []
    #记录最后一次StepFlow的集合
    lastFailActionList = []
    #记录最后一次Trace的状态集合
    lastTraceStatusList = []
    #记录最后一次Run Cnt的结果集合
    lastTraceRunCntList = []
    failAction = "--"
    failInfo = "--"
    nodeResult = "--"
    
    while (time.clock() - startTime) < timeOut:
        #检查设备上是否存在特定告警
        checkAlarmRetDict = checkSysAlarm(cli, lang, ALARM_BLACKLIST,context)
        if not checkAlarmRetDict["flag"]:
            return checkAlarmRetDict
        
        #查询Node Recovery流程状态
        cmd = "show system trace_with_type trace_type=%s" % traceType
        checkRet = cliUtil.execCmdInDeveloperMode(cli, cmd, True, lang)
        cliRet = checkRet[1]
        logger.logInfo("system trace:%s" % str(cliRet))
        if "Current Trace".lower() not in cliRet.lower():
            #未执行到具体Step时，不刷新流程信息
            cliRet = ""
        sysTraceList = cliRet.splitlines()
        
        #将所有的Step涉及的Trace加入到stepFlowList
        stepFlowList = []
        
        traceStatusIdx = 0
        traceCntIdx = 0
        traceStatus = ""
        traceCnt = 0
        for i in xrange(0, len(sysTraceList)):
            sysTrace = sysTraceList[i].strip()
            firstWord = sysTrace.split("  ")[0].strip()
            #获取Status
            if traceStatusIdx == 0 and str(firstWord).lower() == "status" and common.TOTAL_RUN_CNT in sysTrace:
                #Status的值在Status表头的第二行
                traceStatusIdx = i + 2
                traceCntIdx = sysTraceList[i].index(common.TOTAL_RUN_CNT)
                
            #获取Step
            if firstWord.isdigit():
                stepFlow = sysTrace.split("  ")[-1]
                #Steplist中记录Step原始值，用于逻辑判断Step是否执行失败，原始值不可更改
                stepFlowList.append(stepFlow)
                
            #获取Fail Action  
            if "Fail Action".lower() in sysTrace.lower():
                failAction = sysTrace.replace("  ", "")
            #获取Fail Information  
            if "Fail Information".lower() in sysTrace.lower():
                failInfo = sysTrace.replace("  ", "")
            #获取Node Result 
            if "Node Result".lower() in sysTrace.lower():
                nodeResult = sysTrace.replace("  ", "")
        logger.logInfo("stepFlowList=%s" % str(stepFlowList))
            
        if traceStatusIdx < len(sysTraceList):
            line = sysTraceList[traceStatusIdx]
            traceStatus = line.strip().split("  ")[0]
            if traceCntIdx > 0:
                traceCnt = line[traceCntIdx:traceCntIdx+len(common.TOTAL_RUN_CNT)].strip()
                if traceCnt.isdigit() and traceCnt != "0":
                    traceCnt = int(traceCnt)
                    #最后一次Run Cnt的结果记录到集合中
                    lastTraceRunCntList.append(traceCnt)
                    #流程最后执行状态记录到集合中
                    lastTraceStatusList.append(traceStatus)
                    #Fail Action结果记录到集合中
                    lastFailActionList.append(failAction)
            
        logger.logInfo("lastTraceStatusList=%s" % str(lastTraceStatusList))
        logger.logInfo("lastFailActionList=%s" % str(lastFailActionList))
        logger.logInfo("lastTraceRunCntList=%s" % str(lastTraceRunCntList))
        
        #上下文中写入最后一个进度的信息
        if len(stepFlowList) > 0:
            stepInfo = stepFlowList[-1].split(":")[0].strip()
            #由于Step信息过于内部，将加工处理后的Step信息记录到stepFlowShowList
            stepFlowShowList.append(stepInfo)
            remindInfo = common.getRemindInfo(lang, "expansion.show.trace.notice", stepInfo)
            #提示信息相同时，增加后缀区分
            if len(stepFlowShowList) >= 2 and stepFlowShowList[-1] == stepFlowShowList[-2]:
                newStepInfo = "%s (%s)" % (stepInfo, str(common.getLastSameItemCnt(stepFlowShowList)))
                remindInfo = common.getRemindInfo(lang, "expansion.show.trace.notice", newStepInfo)
            context["remindInfo"] = remindInfo
        logger.logInfo("stepFlowShowList=%s" % str(stepFlowShowList))
        
        #如果10分钟内一直执行某个流程且该流程的状态为失败状态则认为该流程上电失败（备注：如果多引擎同时重启，需要修改此超时时间）
        waitCnt = common.SINGLE_STEP_FLOW_CHECK_TIME_LIMIT / common.NEW_CLUSTER_CTRLS_NUM_CHECK_TIME_INTERVAl
        if traceStatus.lower() == "failure" and \
            len(lastTraceRunCntList) >= waitCnt and \
            len(lastTraceStatusList) >= waitCnt:
            if len(set(lastTraceRunCntList[-waitCnt:])) == 1 and \
               len(set(lastTraceStatusList[-waitCnt:])) == 1:
                isTraceFailure = True
            
        #查询控制器数量
        getControllerIdListRet = cliUtil.getControllerIdList(cli, lang)
        if not getControllerIdListRet[0]:
            return common.getSysAbnormalRet(getControllerIdListRet, lang)

        controllerIdList = getControllerIdListRet[1]
        result["ret"] = len(controllerIdList)

        if len(controllerIdList) != requiredCtrlsNum:
            # 原集群控制器数量
            orginCtrlNum = contextUtil.getItem(context, common.EXPANSION_ROLL_BACK_CTRL_NUM_ORIGIN)
            rollbackInfo["orginCtrlNum"] = orginCtrlNum
            rollbackInfo["supportedCtrlNum"] = requiredCtrlsNum
            rollbackInfo["currentCtrlIDList"] = controllerIdList
            rollbackInfo["ruleList"] = common.getRuleList(contextUtil.getItem(context,"ctrlHeight"))
            
            rollbackRet = common.rollBack(context, rollbackInfo)
            # 下发回退命令成功
            if rollbackRet.get("needRollBack") == True:
                result["flag"] = False
                if rollbackRet.get("rollBackResult") == True:
                    result["errMsg"], result["suggestion"] = common.getMsg(lang, "expansion.rollback.success", len(controllerIdList))
                else:
                    result["errMsg"], result["suggestion"] = common.getMsg(lang, "expansion.rollback.failure")
                
                return result
        
            #流程上电失败，提前退出
            if isTraceFailure:
                isCtrlsNumOK = False
                break
            else:
                baseUtil.safeSleep(common.NEW_CLUSTER_CTRLS_NUM_CHECK_TIME_INTERVAl)
        else:
            isCtrlsNumOK = True
            break

    if not isCtrlsNumOK:
        result["flag"] = False
        if failAction.strip() == "--":
            result["errMsg"], result["suggestion"] = common.getMsg(lang, "ctrls.number.wrong.18000.params.null")
        else:
            result["errMsg"], result["suggestion"] = common.getMsg(lang, "ctrls.number.wrong.18000", (failAction, failInfo, nodeResult))
    return result

def updateProcess(context):
    #剩余时间总数
    version = contextUtil.getItem(context, "productVersion")
    totalReaminTime = common.getPoweronCtrlTime(version)
    contextUtil.setItem(context, "totalReaminTime", totalReaminTime)
    context["curRemainTime"] = totalReaminTime
    common.setExpansionProgress(context, True)
    
    while context["checkState"] == CHECK_STATE_CHECKING:

        #检测控制器发现状态,快速刷新，避免等待
        tempTime = 0
        while tempTime < common.NEW_CLUSTER_CTRLS_NUM_CHECK_TIME_INTERVAl:
            # 更新进度条
            if context["curRemainTime"] <= 0:
                context["curRemainTime"] = 1
            context["curRemainTime"] -= CHECK_TIME_INTERVAl
            common.setExpansionProgress(context, True)
            if context["checkState"] == CHECK_STATE_FINISHED:
                break
            tempTime += CHECK_TIME_INTERVAl
            baseUtil.safeSleep(CHECK_TIME_INTERVAl)

    #检查状态为finished时
    context["curRemainTime"] = 0
    common.setExpansionProgress(context, True)

def checkSysAlarm(cli, lang, alarmBlackList,context):
    '''
    @summary: 检查系统是否存在特定告警
    @param cli: cli对象
    @param lang: 语言lang
    @param alarmBlackList: 告警白名单
    @return: 以字典形式返回结果 
        flag: 
            True: 检查通过
            False: 检查不通过
        errMsg: 错误消息
        suggestion: 修复建议
    '''
    result = {"flag":True, "errMsg":"", "suggestion":"", "ret":""}
    
    cmd = "show alarm|filterColumn include columnList=ID,Level"
    checkRet = cliUtil.execCmdInCliMode(cli, cmd, True, lang)
    if not checkRet[0]: 
        return common.getSysAbnormalRet(checkRet, lang)
    
    cliRet = checkRet[1]
    if cliUtil.queryResultWithNoRecord(cliRet):
        return result
    
    cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
    for line in cliRetLinesList:
        if line["Level"].lower() in ["major", "critical"] and line["ID"] in alarmBlackList:
            result["flag"] = False
            result["errMsg"], result["suggestion"] = common.getMsg(lang, "pcie.cable.connect.error")
            return result
    
    return result
    