# -*- coding: UTF-8 -*-
from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common
from cbb.frame.tlv import tlvUtil

#进度总剩余时间
LIMIT_TIME = 30
#进度刷新间隔
INTERVAL = 2

def execute(context):
    '''
    @summary: 修改配置信息
    '''
    try:
        #进度条刷新
        common.threadUpProcess(context, LIMIT_TIME, INTERVAL)
        #进度开始
        common.inProcess(context)
        
        logger = common.getLogger(context.get("logger"), __file__)
        
        newConfigCtrlNum = contextUtil.getItem(context, "newConfigCtrlNum")
        tlvConn =  contextUtil.getTlv(context)

        try:
            contextUtil.setItem(context, contextUtil.EXP_FLOW_STATUS_KEY, contextUtil.EXP_FLOW_STATUS_CHANGE_DATA)
            tlvUtil.modifyCtrlNum(tlvConn, newConfigCtrlNum)
        except Exception as exception:
            lang = contextUtil.getLang(context)
            resultDict = {"flag":False, "errMsg":"", "suggestion":""}
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "modify.config.failure.v3")
            contextUtil.handleException(context, exception, resultDict)
            logger.logException(exception)
            return

        contextUtil.handleSuccess(context)
        logger.logPass()
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
    finally:
        #进度条刷为完成状态
        common.finishProcess(context)
