# -*- coding: UTF-8 -*-
from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common
from cbb.frame.tlv import tlvUtil

def execute(context):
    '''
    @summary: 同步BMC
    '''
    try:
        logger = common.getLogger(context.get("logger"), __file__)
        tlvConn =  contextUtil.getTlv(context)

        try:
            contextUtil.setItem(context, contextUtil.EXP_FLOW_STATUS_KEY, contextUtil.EXP_FLOW_STATUS_CHANGE_DATA)
            tlvUtil.syncBMC(tlvConn)
        except Exception as exception:
            lang = contextUtil.getLang(context)
            resultDict = {"flag":False, "errMsg":"", "suggestion":""}
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "change.config.failure.v3")
            contextUtil.handleException(context, exception, resultDict)
            logger.logException(exception)
            return

        contextUtil.handleSuccess(context)
        logger.logPass()
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
