# -*- coding: UTF-8 -*-
from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common

def execute(context):
    '''
    @summary: 修改已扩容引擎管理IP
    '''
    
    try:
        logger = common.getLogger(context.get("logger"), __file__)
        
        cli = contextUtil.getCli(context)
        lang = contextUtil.getLang(context)
        
        ipVer = contextUtil.getItem(context, "ipVer")
        newBayIds = ["0"]
        manIpList = contextUtil.getItem(context, "manIpList")
        
        manPortIdListRet = common.getManPortIdList(cli, lang)
        if manPortIdListRet["flag"] != True:
            logger.logNoPass("Getting management ports failure")
            contextUtil.handleFailure(context, manPortIdListRet)
            return
            
        manPortIdDict = {}
        for manPortId in manPortIdListRet["ret"]:
            if "A" in manPortId:
                continue
            manPortArr = manPortId.split(".")
            if len(manPortArr) != 3:
                continue
            eng = manPortArr[0][-1]
            slot = manPortArr[1][-1]
            if eng not in newBayIds:
                continue
            
            if not manPortIdDict.has_key(eng):
                slotsDict = {}
                slotsDict[slot] = [manPortId]
            else:
                slotsDict = manPortIdDict.get(eng)
                if slotsDict.has_key(slot):
                    newManPortIdList = slotsDict.get(slot)
                    newManPortIdList.append(manPortId)
                    slotsDict[slot] = newManPortIdList
                else:
                    slotsDict[slot] = [manPortId]
            manPortIdDict[eng] = slotsDict.copy()
        logger.logInfo("manPortIdDict:%s" % manPortIdDict)
        
        manIpDictList = []
        for eng in manPortIdDict.keys():
            slotsDict = manPortIdDict.get(eng)
            slots = slotsDict.keys()
            slots.sort()
            for i in range(0, len(slots)):
                manIp = common.getManIP(manIpList, eng, i)
                mask = common.getMask(manIpList, eng, i)
                gateway = common.getGateway(manIpList, eng, i)
                if len(manIp) == 0:
                    continue
                
                manIpDict = {}
                manIpDict["eth_port_id"] = slotsDict.get(slots[i])[0]
                manIpDict["address"] = manIp
                manIpDict["mask"] = mask
                manIpDict["gateway"] = gateway
                manIpDictList.append(manIpDict.copy())

        logger.logInfo("manIpDictList:%s" % manIpDictList)
        #修改待扩容控制器管理网口IP
        modifyManIPRetDict = common.modifyManIPSingle(cli, lang, manIpDictList, ipVer)
        logger.logInfo("config management IP results:%s" % modifyManIPRetDict["ret"])
        if not modifyManIPRetDict["flag"]:
            contextUtil.handleFailure(context, modifyManIPRetDict)
            return
        
        contextUtil.handleSuccess(context)
        logger.logPass()
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
