# -*- coding: UTF-8 -*-
from cbb.frame.context import contextUtil
from cbb.frame.cli import cliUtil
from cbb.business.operate.expansion import common

def execute(context):
    '''
    @summary: 执行扩容控制器
    '''
    try:
        logger = common.getLogger(context.get("logger"), __file__)
        
        lang = contextUtil.getLang(context)
        cli = contextUtil.getCli(context)
        
        try:
            #下发扩容CLI
            isSuccess = cliUtil.expandCtrlCapacityFor2800(cli,lang)
            if isSuccess[0] == False:
                resultDict = {"flag":False, "errMsg":"", "suggestion":""}
                resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "notify.expansion.failure.2800")
                contextUtil.handleFailure(context, resultDict)
                return
        except Exception as exception:
            resultDict = {"flag":False, "errMsg":"", "suggestion":""}
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "notify.expansion.failure.v3")
            contextUtil.handleFailure(context, resultDict)
            logger.logException(exception)
            return
        
        logger.logInfo("excute expansion")
        contextUtil.handleSuccess(context)
        logger.logPass()
        return
        
    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
