# -*- coding: UTF-8 -*-

from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common

def saveData(context):
    '''
    @summary: 保存已扩容引擎管理IP
    '''
    
    try:
        logger = common.getLogger(context.get("logger"), __file__)
        lang = contextUtil.getLang(context)
        
        ipVer = contextUtil.getItem(context, "ipVer")
        
        #只保存一个新引擎的管理IP，其他引擎管理IP不配置
        newBayId = 0
        manIpList = []
        manIpList.append({"bayid":newBayId, "slot":0, 
          "manIp":context["input_configManIPSingle_eng%s.ip" % newBayId],
          "mask":context["input_configManIPSingle_eng%s.mask" % newBayId],
          "gateway":context["input_configManIPSingle_eng%s.gateway" % newBayId]})
        
        allManIps = []    
        for manIpDict in manIpList:
            ctrlIpAddr = manIpDict["manIp"]
            mask = manIpDict["mask"]
            gateway = manIpDict["gateway"]
            allManIps.append(ctrlIpAddr)
            
            if not common.isIllegalManIpAddr(ctrlIpAddr, ipVer):
                errMsg, suggestion = common.getMsg(lang, "ctrl.ip.addr.invalid", (ipVer, ""))
                resultDict = {"flag":False, "errMsg":errMsg, "suggestion":suggestion}
                contextUtil.handleFailure(context, resultDict)
                return

            if not common.isIllegalMask(mask, ipVer):
                if ipVer == common.IPV4:
                    errMsg, suggestion = common.getMsg(lang, "ctrl.ip.mask.invalid", "")
                    resultDict = {"flag":False, "errMsg":errMsg, "suggestion":suggestion}
                    contextUtil.handleFailure(context, resultDict)
                    return
                else:
                    errMsg, suggestion = common.getMsg(lang, "ctrl.ip.prefix.invalid", "")
                    resultDict = {"flag":False, "errMsg":errMsg, "suggestion":suggestion}
                    contextUtil.handleFailure(context, resultDict)
                    return

            if (gateway is not None and gateway != "") and not common.isIllegalGateway(gateway, ipVer):
                errMsg, suggestion = common.getMsg(lang, "ctrl.ip.gateway.invalid", "")
                resultDict = {"flag":False, "errMsg":errMsg, "suggestion":suggestion}
                contextUtil.handleFailure(context, resultDict)
                return
            
            #验证新设置的ip是否与原IP冲突
            accessIP = contextUtil.getDevObj(context).get("ip")
            if ctrlIpAddr == accessIP:
                errMsg, suggestion = common.getMsg(lang, "eng.ip.conflict")
                resultDict = {"flag":False, "errMsg":errMsg, "suggestion":suggestion}
                contextUtil.handleFailure(context, resultDict)
                return
            
        logger.logInfo("manIpList:%s" % manIpList)
        contextUtil.setItem(context, "manIpList", manIpList)
        contextUtil.handleSuccess(context)
        logger.logPass()
        return
        
    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return

def getItems(context, param):
    try:
        logger = common.getLogger(context.get("logger"), __file__)
        
        ipVer = contextUtil.getItem(context, "ipVer")
        resultList = []
        
        newBayId = 0
            
        idIp1 = "eng%s.ip" % newBayId
        idMask1 = "eng%s.mask" % newBayId
        idGateway1 = "eng%s.gateway" % newBayId
        
        labelIp1 = "manIPSingle.eng.%s.ip" % ipVer
        labelMask1 = "manIPSingle.eng.%s.mask" % ipVer
        labelGateway1 = "manIPSingle.eng.%s.gateway" % ipVer
            
        ip1 = {"id":idIp1,"type":"text","label":labelIp1,"default":""}
        mask1 = {"id":idMask1,"type":"text","label":labelMask1,"default":""}
        gateway1 = {"id":idGateway1,"type":"text","label":labelGateway1,"default":""}
        resultList.extend([ip1, mask1, gateway1])
        
        sep = {"id":"sep", "type":"3seperator"}
        resultList.append(sep)
            
        context["retData"] = common.dictList2JsonArray(resultList)
        contextUtil.handleSuccess(context)
        
        logger.logPass()
        return
        
    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
    return
