# -*- coding: UTF-8 -*-

from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common


def cancel(context):
    """
    弹出SMB已开启提示框
    """
    logger = common.getLogger(context.get("logger"), __file__)
    try:
        # 弹出提示框，SMB开关已开启
        lang = contextUtil.getLang(context)
        cifs_status = contextUtil.getItem(context, "cifs_status")
        if cifs_status == "No":
            dialog_util = context.get("dialogUtil")
            err_msg = common.getRes(lang, "SMB_tasks_has_open")
            next_proc = dialog_util.showInfoDialog(err_msg)
            context["nextProc"] = next_proc
            context["remind"] = True
            context["isRefresh"] = False
            contextUtil.setItem(context, "cifs_status", None)
        else:
            context["succ"] = True
            return
    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
