# -*- coding: UTF-8 -*-

from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common

def cancel(context):
    '''
    @summary: 扩容中，用户点击取消时按钮时处理
    '''
    
    try:
        resultDict = {"flag":True, "errMsg":"", "suggestion":""}
        logger = common.getLogger(context.get("logger"), __file__)
        lang = contextUtil.getLang(context)
        
        errMsgKey = "expansion.cancel.prompt.ipscaleout"
        
        resultDict["flag"] = False
        resultDict["errMsg"],resultDict["suggestion"] = common.getMsg(lang, errMsgKey)
        contextUtil.handleFailure(context, resultDict)
        return
    
    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
