
# -*- coding: UTF-8 -*-

from __future__ import with_statement

import os
import ast

from cbb.business.operate.expansion import common
from cbb.business.operate.expansion import config
from cbb.frame.cli import cliUtil
from cbb.frame.context import contextUtil

# 配置数据持久化目录
CFG_DATA_PERSIST_DIR = "\\temp\\expanEval"

# 目录分割
FILE_DEPSIGN = "\\"

CFG_DATA_PERSIST_FILENAME = "expansionEvalConfig.dat"
#向上两级目录
DIR_RELATIVE_CMD = "..\.."

#进度总剩余时间
LIMIT_TIME = 120
#进度刷新间隔
INTERVAL = 2

def execute(context):
    '''
    @summary: check the config data consitence
    '''

    try:
        #进度条刷新
        common.threadUpProcess(context, LIMIT_TIME, INTERVAL)
        
        resultDict = {"flag":True, "errMsg":"", "suggestion":""}
        logger = common.getLogger(context.get("logger"), __file__)
        
        cli = contextUtil.getCli(context)
        lang = contextUtil.getLang(context)
        freeDiskList = cliUtil.getFreeDisks(cli, lang)
        logger.logInfo("freeDiskList:%s"% freeDiskList)
        if not freeDiskList or len(freeDiskList) == 0:
            logger.logNoPass("expdd.check.config.data.nil.disk")
            resultDict["flag"] = False
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "expdd.check.config.data.nil.disk")
            contextUtil.handleFailure(context, resultDict)
            return
        
        productModel = contextUtil.getItem(context, "productModel")
        errMsg = ""
        checkFlag = True
        realData = {}
        for aDiskInfo in freeDiskList:
            diskId = aDiskInfo.get("ID")
            diskCapacity = aDiskInfo.get("Capacity")
            diskModel = aDiskInfo.get("Type")
            engId = getLogicEngIdByDiskId(diskId, productModel)
            realData[engId] = realData.get(engId, 0) + 1
            
            # 通过电子标签比较容量
            isQrySucc, elabeldiskCapacity, _ = common.getDiskCapacityByDiskId(cli, diskId, lang, isOrigin=True)
            if isQrySucc:
                # 引擎上的某种容量点的盘数字典
                baseDiskCapacity2GB = common.changUnit2GBLabelCap(elabeldiskCapacity)
                realData[(engId, baseDiskCapacity2GB[1])] = realData.get((engId, baseDiskCapacity2GB[1]), 0) + 1
                realData[(engId, baseDiskCapacity2GB[1], diskModel)] = realData.get((engId, baseDiskCapacity2GB[1], diskModel), 0) + 1
        logger.logInfo("realData:%s"% realData)
        
        # 比较配置的硬盘容量和电子标签容量
        cfgData = getConfigData(logger)
        for aRow in cfgData.values():
            domainId = aRow.get("domainId")
            diskNum = aRow.get("diskNum")
            diskCapacity = aRow.get("diskCapacity")
            engine = aRow.get("engine")
            diskModel = aRow.get("diskModel")
            cfgSingleEngineNum = diskNum / len(engine)
            for anEngId in engine:
                # 开始比较
                realDiskNum = realData.get((anEngId, diskCapacity, diskModel), 0)
                logger.logInfo("realDiskNum:%s"% str(realDiskNum))
                
                if realDiskNum < cfgSingleEngineNum:
                    checkFlag = False
                    errMsg += common.getMsg(lang, "expdd.check.realnum.not.equal.to.confignum", 
                        (domainId, anEngId, diskCapacity, realDiskNum, cfgSingleEngineNum))[0]
                    continue
        if not checkFlag:
            logger.logNoPass("expdd.check.realnum.not.equal.to.confignum")
            resultDict["flag"] = False
            resultDict["errMsg"] = common.getMsg(lang, "expdd.check.match.error")[0]
            resultDict["suggestion"] = errMsg + common.getMsg(lang, "expdd.check.match.suggestion")[1]
            contextUtil.handleFailure(context, resultDict)
            return
        contextUtil.setItem(context, "EXPAND_DD_EVAL_CONFIG_DATA", cfgData)
        contextUtil.handleSuccess(context)
        logger.logPass()
        return
    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
    finally:
        #进度条刷为完成状态
        common.finishProcess(context)

def getConfigData(logger):
    try:
        # 工具箱基本目录
        baseDir = os.path.abspath(DIR_RELATIVE_CMD)
        persistDir = baseDir + CFG_DATA_PERSIST_DIR
        isExistsDataDir = os.path.exists(persistDir)
        if not isExistsDataDir:
            logger.logInfo("The persist directory does not exist: %s" % persistDir)
            os.makedirs(persistDir)
        
        persistFile = persistDir + FILE_DEPSIGN + CFG_DATA_PERSIST_FILENAME
        with open(persistFile, 'r') as fileObj:
            configData = fileObj.read()
            configDataDict = ast.literal_eval(unicode(configData))
            logger.logInfo("saveConfigData is: %s" % configDataDict)
    except Exception as ex:
        logger.logInfo("saveConfigData exception: %s" % ex)
        return {}
    return configDataDict

def getLogicEngIdByDiskId(diskId, productModel=""):
    """
    根据disk_id获取逻辑引擎ID
    """
    if "CTE" in diskId:
        return diskId[3]
    
    if len(diskId) < 5:
        return ""
    
    if productModel in config.SMALL_SAS_6U_PRODUCTS:
        pEng = int(diskId[3]) * 2
        if diskId[4] >= "8":
            return str(pEng + 1)
        else:
            return str(pEng)
        
    else:
        return diskId[3]
    