# -*- coding: UTF-8 -*-
from cbb.frame.context import contextUtil
from cbb.frame.rest import restData
from cbb.frame.rest import restUtil
from cbb.business.operate.expansion import common

#进度总剩余时间
LIMIT_TIME = 120
#进度刷新间隔
INTERVAL = 2

def execute(context):
    '''
    @summary: 执行扩容硬盘域
    '''
    
    try:
        #进度条刷新
        common.threadUpProcess(context, LIMIT_TIME, INTERVAL)
        
        logger = common.getLogger(context.get("logger"), __file__)
        lang = contextUtil.getLang(context)
        domainId = ""
        try:
            cfgData = contextUtil.getItem(context, "EXPAND_DD_EVAL_CONFIG_DATA")
            for aRowData in cfgData.values():
                domainId = aRowData.get("domainId")
                diskNum = aRowData.get("diskNum")
                diskCapacity = int(aRowData.get("diskCapacity"))
                diskCapacityGB = common.changUnit2GBLabel2DevCap(str(diskCapacity) + "GB")
                expanDiskDomain(context, domainId, diskNum, int(diskCapacityGB[1]))
        except Exception as exception:
            logger.logInfo("exception error code is %s" % exception[0])
            errorMsgKey = "expdd.errorcode." + str(exception[0])
            resultDict = {"flag":False, "errMsg":"", "suggestion":""}
            resultDict["errMsg"] = common.getMsg(lang, "expdd.check.error.common.info", domainId)[0]
            resultDict["suggestion"] = common.getMsg(lang, errorMsgKey)[1]
            contextUtil.handleException(context, exception, resultDict)
            logger.logException(exception)
            return
        logger.logInfo("excute expansion finished")
        contextUtil.handleSuccess(context)
        logger.logPass()
        return
    
    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
    finally:
        #进度条刷为完成状态
        common.finishProcess(context)


def expanDiskDomain(context, domain_id, disk_num, disk_capacity):
    '''
    @summary: 执行扩容硬盘域——支持选盘，当前支持V3R2C00
    '''
    # 下发扩容评估命令
    uri_param_dict = restUtil.CommonRest.getUriParamDict(restData.RestCfg.OBJ.EXPANSION_DISKDOMAIN, [domain_id])
    rest = contextUtil.getRest(context)
    disk_num_list = []
    disk_num_list.append("" + str(disk_num))
    disk_capacity_list = []
    disk_capacity_list.append("" + str(disk_capacity))
    record = restUtil.CommonRest.execCmd(rest, uri_param_dict,
                                         {"TYPE": restData.Enum.ObjectEnum.DiskPool, "ID": domain_id,
                                          "diskNumList": disk_num_list,
                                          "diskCapacityList": disk_capacity_list},
                                         restData.RestCfg.RestMethod.PUT)
    return record
