# -*- coding: UTF-8 -*-
# noinspection PyUnresolvedReferences
from java.lang import Throwable

from cbb.business.operate.expansion import common
from cbb.business.operate.expansion import config
from cbb.frame.context import contextUtil
from cbb.frame.tlv import tlvUtil


def execute(context, param):
    """检查SES版本一致性

    :param context: 上下文
    :param param: 参数
    :return:
    """
    logger = common.getLogger(context.get("logger"), __file__)
    lang = contextUtil.getLang(context)
    try:
        tlv = contextUtil.getTlv(context)

        # 扩容前硬盘框数量
        diskEncNum = contextUtil.getItem(context, "diskEnclosureNum")

        # 扩容后硬盘框数量
        enclosureRecords = tlvUtil.getEnclosureRecords(tlv)
        currdiskEncNum = len(tlvUtil.getDiskEnclouresName(enclosureRecords))
        logger.logInfo("current disk enclosure number:%s, before "
                       "expansion number:%s" % (currdiskEncNum, diskEncNum))
        isDoradoV6 = contextUtil.getItem(context, 'isV5V6HighEnd', False)
        if isDoradoV6:
            totalReaminTime = config.DORADO_V6_DISK_FW_SYNC_TIME_OUT
        else:
            totalReaminTime = config.PER_CHECK_FW_TIME * (
                    abs(currdiskEncNum - diskEncNum) + 1)

        logger.logInfo("is V5 OR V6 high end:%s, check disk firmware max "
                       "time out(seconds):%s" % (isDoradoV6, totalReaminTime))

        # 剩余时间总数
        contextUtil.setItem(context, "totalReaminTime", totalReaminTime)
        context["curRemainTime"] = totalReaminTime
        common.setExpansionProgress(context, True)

        # 检查SES、CPLD版本一致性
        checkExpModuleSESVersionsRetDict = \
            common.checkExpModuleSESVersions(context, totalReaminTime)

        if not checkExpModuleSESVersionsRetDict["flag"]:
            logger.logNoPass("check SES versions failure")
            contextUtil.handleFailure(context,
                                      checkExpModuleSESVersionsRetDict)
            return

        contextUtil.handleSuccess(context)
        logger.logPass()
        return

    except Throwable as t:
        contextUtil.handleNetworkFailure(context, lang)
        logger.logException(t)

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
    finally:
        context["curRemainTime"] = 0
        common.setExpansionProgress(context, True)
