# -*- coding: UTF-8 -*-

from cbb.business.operate.expansion import common
from cbb.business.operate.expansion import enclosureCommon
from cbb.frame.context import contextUtil
from cbb.frame.tlv import tlvUtil


def execute(context, param):
    '''
    @summary: 检查硬盘框类型
    '''

    logger = common.getLogger(context.get("logger"), __file__)
    try:
        resultDict = {"flag": True, "errMsg": "", "suggestion": ""}

        lang = contextUtil.getLang(context)
        tlv = contextUtil.getTlv(context)

        cabinetRecords = tlvUtil.getBayRecords(tlv)
        cabinetDict = tlvUtil.getCabinetDict(cabinetRecords)
        logger.logInfo("cabinetDict:%s" % str(cabinetDict))
        contextUtil.setItem(context, "cabinetDict", cabinetDict)

        if enclosureCommon.isNewExpansion(context):
            cabinetInfoDict = enclosureCommon.getCabinetInfoDict(context, tlv)
            checkResult = enclosureCommon.checkEnclosureModel(cabinetInfoDict)
        else:
            cabinetInfoDict = common.getCabinetInfoDict(context, tlv)
            checkResult = common.checkEnclosureModel(cabinetInfoDict)
        logger.logInfo("check enclosure type consistent result:%s" % str(checkResult))
        if not checkResult[0]:
            resultDict["flag"] = False
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang,
                                                                           "cluster.disk.enclosure.not.match",
                                                                           ', '.join(checkResult[1]))
            contextUtil.handleFailure(context, resultDict)
            return

        contextUtil.handleSuccess(context)
        logger.logPass()
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
