# -*- coding: UTF-8 -*-

import time

from cbb.business.operate.expansion import common
from cbb.frame.base import baseUtil
from cbb.frame.base import funcUtils
from cbb.frame.context import contextUtil
from cbb.frame.tlv import tlvUtil


@funcUtils.fakeProgress(totalSecs=common.TIME_OUT_EXP_ENC, intervalSec=5)
def execute(context, param):
    '''
    @summary: 检查电源线
    '''

    logger = common.getLogger(context.get("logger"), __file__)
    try:
        resultDict = {"flag": True, "errMsg": "", "suggestion": ""}

        lang = contextUtil.getLang(context)
        tlv = contextUtil.getTlv(context)

        originEncNum = contextUtil.getItem(context, "diskEnclosureNum", 0)

        expectNewEncNum = contextUtil.getItem(context, 'newEnc2UNum', 0)
        expectedEncNum = expectNewEncNum + originEncNum

        isPowerOn = True
        startTime = time.time()
        encList = []
        while (time.time() - startTime) < common.TIME_OUT_EXP_ENC:
            # 检查新增硬盘框是否能全部查询
            records = tlvUtil.getEnclosureRecords(tlv)
            encList = tlvUtil.getDiskEnclouresName(records)

            # 暂时只检查所有新扩容硬盘是否都接入成功（不检查标准位置）。
            if check_new_enc_poweron(context, records, expectNewEncNum) and \
                    len(encList) >= expectedEncNum:
                logger.logInfo("All new disk enclosures may have come in.")
                isPowerOn = True
                break
            else:
                isPowerOn = False

            # 每30秒查询一次
            if not isPowerOn:
                baseUtil.safeSleep(30)
            else:
                break

        if not isPowerOn:
            originDaeNameSet = contextUtil.getItem(context,
                                                   'originDiskEncNameList',
                                                   set())
            newInsertedEncList = list(
                filter(lambda daeName: daeName not in originDaeNameSet,
                       encList))
            logger.logInfo(
                "new inserted disk enclosure num:%d is not equal to "
                "input num:%d"
                % (len(newInsertedEncList), expectNewEncNum))
            resultDict["flag"] = False
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(
                lang, "cluster.checkPoweron.timeout",
                (len(newInsertedEncList), expectNewEncNum))
            contextUtil.handleFailure(context, resultDict)
            return

        contextUtil.handleSuccess(context)
        logger.logPass()
    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return


def check_new_enc_poweron(context, records, expect_new_enc_num):
    """检查新扩框是否已接入

    :param context:
    :param records:
    :param expect_new_enc_num:
    :return:
    """
    logger = common.getLogger(context.get("logger"), __file__)
    # 原硬盘框列表
    origin_dae_names = list(contextUtil.getItem(
        context, 'originDiskEncNameList', set()))
    new_disk_encs, _ = tlvUtil.get_new_disk_enc(records, origin_dae_names)
    logger.logInfo("origin disk enclosure: %s" % str(origin_dae_names))
    logger.logInfo("new disk enclosure: %s" % str(new_disk_encs))
    return len(new_disk_encs) >= expect_new_enc_num
