# -*- coding: UTF-8 -*-

import time

from cbb.business.operate.expansion import common
from cbb.common.conf.productConfig import DAE_POWER_ON_SECS
from cbb.common.dev.utils import isDevMode
from cbb.common.dev.utils import skipDaePoweronCheck
from cbb.frame.base import baseUtil
from cbb.frame.context import contextUtil
from cbb.frame.devGraph import dorodaoV6HighEndGraphUtil as graphUtil
from cbb.frame.tlv import tlvUtil
from expandDisk.common.checkPowerOn import check_new_enc_poweron


def execute(context, param):
    '''
    @summary: 检查电源线
    '''

    logger = common.getLogger(context.get("logger"), __file__)
    try:
        if skipDaePoweronCheck():
            new_inserted_enc_list = ["DAE000"]
            contextUtil.setItem(
                context, "newInsertedEncList", new_inserted_enc_list)
            contextUtil.handleSuccess(context)
            logger.logPass()
            return

        resultDict = {"flag": True, "errMsg": "", "suggestion": ""}

        lang = contextUtil.getLang(context)
        tlv = contextUtil.getTlv(context)

        originEncNum = contextUtil.getItem(context, "diskEnclosureNum", 0)
        newDaeNum = len(
            contextUtil.getItem(context, 'doradoV6HighEndNewDaes', []))
        expectedEncNum = originEncNum + newDaeNum

        # 设置检查时间
        daeType = contextUtil.getItem(context, "daeEnclosureType")
        daePowerOnTimeSecs = DAE_POWER_ON_SECS.get(daeType, 5 * 60) \
            if not isDevMode() else 30
        contextUtil.setItem(context, "totalReaminTime", daePowerOnTimeSecs)
        curRemainTime = daePowerOnTimeSecs
        context["curRemainTime"] = daePowerOnTimeSecs
        common.setExpansionProgress(context)

        isPowerOn = True
        startTime = time.time()
        encList = []
        while (time.time() - startTime) < daePowerOnTimeSecs:
            # 检查新增硬盘框是否能全部查询
            records = tlvUtil.getEnclosureRecords(tlv)
            encList = tlvUtil.getDiskEnclouresName(records)

            # 暂时只检查所有新扩容硬盘是否都接入成功（不检查标准位置）。
            if check_new_enc_poweron(context, records, newDaeNum) and \
                    len(encList) >= expectedEncNum:
                logger.logInfo("All new disk enclosures may have come in.")
                isPowerOn = True
                break
            else:
                isPowerOn = False

            # 每30秒查询一次
            if not isPowerOn:
                baseUtil.safeSleep(30)
                curRemainTime -= 30  # 更新时间进度
                context["curRemainTime"] = curRemainTime
                common.setExpansionProgress(context)
            else:
                break

        # 保存新扩硬盘框框列表
        origin_dae_name_set = contextUtil.getItem(
            context, 'originDiskEncNameList', set())
        new_inserted_enc_list = list(
            filter(lambda dae_name: dae_name not in origin_dae_name_set,
                   encList))
        contextUtil.setItem(
            context, "newInsertedEncList", new_inserted_enc_list)

        if not isPowerOn:
            logger.logInfo(
                "new inserted disk enclosure num:%d is not "
                "equal to input num:%d"
                % (len(new_inserted_enc_list), newDaeNum))
            resultDict["flag"] = False
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(
                lang, "cluster.checkPoweron.timeout",
                (len(new_inserted_enc_list), newDaeNum))
            contextUtil.handleFailure(context, resultDict)
            return

        graphUtil.drawGraph(context, {"isBack": True})
        contextUtil.handleSuccess(context)
        logger.logPass()
    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
    finally:
        context["curRemainTime"] = 0
        common.setExpansionProgress(context, True)
