# -*- coding: UTF-8 -*-

import time

from cbb.frame.base import funcUtils
from cbb.business.operate.expansion import common
from cbb.common.dev.utils import skipDaePoweronCheck
from cbb.frame.base import baseUtil
from cbb.frame.context import contextUtil
from cbb.frame.devGraph import graphUtil
from cbb.frame.tlv import tlvUtil


@funcUtils.fakeProgress(totalSecs=common.TIME_OUT_EXP_ENC, intervalSec=5)
def execute(context, param):
    """检查新增硬盘框上电状态

    :param context:
    :param param:
    :return:
    """
    logger = common.getLogger(context.get("logger"), __file__)
    try:
        if skipDaePoweronCheck():
            newInsertedEncList = ["SMB0.3U"]
            contextUtil.setItem(
                context, "newInsertedEncList", newInsertedEncList)
            logger.logInfo("check power on V5 HIGH.")
            contextUtil.handleSuccess(context)
            logger.logPass()
            return

        resultDict = {"flag": True, "errMsg": "", "suggestion": ""}

        lang = contextUtil.getLang(context)
        tlv = contextUtil.getTlv(context)

        originEncNum = contextUtil.getItem(context, "diskEnclosureNum", 0)
        newEnc2UList = contextUtil.getItem(context, "newEnc2UList", [])
        newEnc4UList = contextUtil.getItem(context, "newEnc4UList", [])
        newEnc2UNVMeList = contextUtil.getItem(context, "newEnc2UNVMeList", [])
        newEncList = newEnc2UList + newEnc4UList + newEnc2UNVMeList
        expectNewEncNum = len(newEncList)
        expectedEncNum = expectNewEncNum + originEncNum

        startTime = time.time()
        encList = []
        while (time.time() - startTime) < common.TIME_OUT_EXP_ENC:
            # 检查新增硬盘框是否能全部查询
            records = tlvUtil.getEnclosureRecords(tlv)
            encList = tlvUtil.getDiskEnclouresName(records)

            # 暂时只检查所有新扩容硬盘是否都接入成功（不检查标准位置）。
            if check_new_enc_poweron(context, records, expectNewEncNum) and \
                    len(encList) >= expectedEncNum:
                logger.logInfo("All new disk enclosures may have come in.")

                graphUtil.drawGraphForExp(context, {"isBack": True})
                contextUtil.handleSuccess(context)
                logger.logPass()
                return

            # 每30秒查询一次
            baseUtil.safeSleep(30)

        new_inserted_dae_num = contextUtil.getItem(context,
                                                   "new_inserted_dae_num",
                                                   0)
        logger.logInfo(
            "new inserted disk enclosure num:%d is not "
            "equal to input num:%d"
            % (new_inserted_dae_num, expectNewEncNum))
        resultDict["flag"] = False
        resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(
            lang, "cluster.checkPoweron.timeout",
            (new_inserted_dae_num, expectNewEncNum))
        contextUtil.handleFailure(context, resultDict)
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return


def check_new_enc_poweron(context, records, expect_new_enc_num):
    """检查新扩框是否已接入

    :param context:
    :param records:
    :param expect_new_enc_num:
    :return:
    """
    logger = common.getLogger(context.get("logger"), __file__)
    # 原硬盘框列表
    origin_dae_names = list(contextUtil.getItem(
        context, 'originDiskEncNameList', set()))
    new_disk_encs, new_encs_loc_list = \
        tlvUtil.get_new_disk_enc(records, origin_dae_names)
    logger.logInfo("origin disk enclosure: %s" % str(origin_dae_names))
    logger.logInfo("new disk enclosure names: %s, locations: %s." % (
        str(new_disk_encs), str(new_encs_loc_list)))
    contextUtil.setItem(
        context, "new_inserted_dae_num", len(new_disk_encs))
    contextUtil.setItem(
        context, "newInsertedEncList", new_encs_loc_list)
    return len(new_disk_encs) >= expect_new_enc_num
