# -*- coding: UTF-8 -*-
from cbb.frame.base import funcUtils
from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common
from cbb.common.dev.utils import skipAlarmCheck
import time


@funcUtils.fakeProgress(totalSecs=2 * 60, intervalSec=1)
def execute(context, param=0):
    """检查设备上是否存在特定告警

    :param context:
    :param param: 睡眠时间
    :return:
    """
    logger = common.getLogger(context.get("logger"), __file__)
    try:
        if skipAlarmCheck():
            logger.logInfo("run in developer mode, skip alarm check directly.")
            contextUtil.handleSuccess(context)
            return

        cli = contextUtil.getCli(context)
        lang = contextUtil.getLang(context)

        # 检查设备上是否存在特定告警
        if param:
            logger.logInfo("args:%s, type:%s" % (param, type(param)))
            time.sleep(int(str(param)))

        check_alarm_ret_dict = common.checkSysAlarm(
            cli, lang, common.PRE_CHECK_ALARM_WHITELIST)
        if not check_alarm_ret_dict["flag"]:
            logger.logNoPass("System exists major or critical alarms")
            contextUtil.handleFailure(context, check_alarm_ret_dict)
            return

        contextUtil.handleSuccess(context)
        logger.logPass()
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
