# -*- coding: UTF-8 -*-

from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common
from cbb.frame.tlv import tlvUtil
from cbb.frame.tlv import tlvData

def execute(context):
    """检查业务压力

    :param context:
    :return:
    """

    logger = common.getLogger(context.get("logger"), __file__)
    try:

        #检查控制器CPU利用率
        checkCpuUsageRet = checkCpuUsage(context)
        if not checkCpuUsageRet[0]:
            contextUtil.handleFailure(context, checkCpuUsageRet[1])
            return

        #检查后端IO并发数
        checkBackIoRet = checkBackIoConcurrent(context)
        if not checkBackIoRet[0]:
            contextUtil.handleFailure(context, checkBackIoRet[1])
            return

        contextUtil.handleSuccess(context)
        logger.logPass()
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return



def checkCpuUsage(context):
    '''
    @summary:检查所有控制框中所有控制器的CPU利用率
            原理；先分别按框计算CPU的利用率之和，若实际利用率超过最大允许利用率，则检查不通过，否则通过。
    '''    
    resultDict = {"flag":True, "errMsg":"", "suggestion":""}
    logger = common.getLogger(context.get("logger"), __file__)
    lang = contextUtil.getLang(context)
    tlv = contextUtil.getTlv(context)
    
    #检查控制器CPU利用率
    cpuUsageList = tlvUtil.getAllCpuUsage(tlv)
    logger.logInfo("cpuUsageList:%s" % cpuUsageList)
    for cpuUsageInfo in cpuUsageList:
        cpuUsage = cpuUsageInfo["cpuUsage"]
        controllerID = cpuUsageInfo["ctrlId"]
        if not cpuUsage.isdigit():
            logger.logNoPass("Get CPU usage failure(cpuUsage:%s, controllerID:%s)" % 
             (cpuUsage, controllerID))
            resultDict["flag"] = False
            resultDict["errMsg"],resultDict["suggestion"] = common.getMsg(lang, "old.get.cpu.usage.failure")
            return (False, resultDict)
        if int(cpuUsage) > common.MAX_CPU_USAGE:
            logger.logNoPass("The controller CPU usage is higher than %s(cpuUsage:%s, controllerID:%s)" % 
             (common.MAX_CPU_USAGE, cpuUsage, controllerID))
            resultDict["flag"] = False
            resultDict["errMsg"],resultDict["suggestion"] = common.getMsg(lang, "old.cpu.usage.check.failure", 
             "%s%s" % (common.MAX_CPU_USAGE, "%"))
            return (False, resultDict)
    return (True,{})

def checkBackIoConcurrent(context):
    '''
    @summary:检查本控制框中后端IO并发数
    '''
    resultDict = {"flag":True, "errMsg":"", "suggestion":""}
    logger = common.getLogger(context.get("logger"), __file__)
    lang = contextUtil.getLang(context)
    #获取系统中的所有控制器信息
    tlv = contextUtil.getTlv(context)
    allCtrlsRecords = tlvUtil.getControllerRecords(tlv) 
       
    #获取所有引擎框信息
    allEngIds = tlvUtil.getEngineEnclosureID(tlv)
    
    #检查后端业务压力
    for engineId in allEngIds:
        
        totalBackIO = 0
        totalBackLimintIO = 0
        
        #检查对应引擎下控制器的后端业务压力
        for  ctrlRecord in allCtrlsRecords:
            parentId = tlvUtil.getRecordValue(ctrlRecord, tlvData.PUB_ATTR["parentID"])
            if engineId != parentId:
                continue
            
            ctrlId = tlvUtil.getRecordValue(ctrlRecord, tlvData.PUB_ATTR["id"])
            backIoConcurrentRec = tlvUtil.getBackIoConcurrent(tlv, ctrlId)
            logger.logInfo("get back IO record: %s" %str(backIoConcurrentRec))
            totalBackIO += int(tlvUtil.getRecordValue(backIoConcurrentRec, tlvData.CONTROLLER_IO["backEndIO"]))
            totalBackLimintIO += int(tlvUtil.getRecordValue(backIoConcurrentRec, tlvData.CONTROLLER_IO["backEndLimit"]))

        if totalBackIO >= totalBackLimintIO > 0:
            logger.logInfo("The back end IO is too high:%s (totalBackIo:%s,LimintIO: %s)" % (
            engineId, str(totalBackIO), str(totalBackLimintIO)))
            resultDict["flag"] = False
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "system.backIo.check.failure")
            return (False, resultDict)
    
    return (True,{})
        