# -*- coding: UTF-8 -*-

from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common
import os


def execute(context, param):
    """获取帮助文档

    :param context:
    :param param:
    :return:
    """

    logger = common.getLogger(context.get("logger"), __file__)
    try:
        lang = contextUtil.getLang(context)
        rootPath = contextUtil.getImportRootDir(context)

        if str(param) == "move_sas_card":
            context["doc_link"] = os.path.join(rootPath, "res", "help", 'moveCard',
                                               "moveSASInterfaceModule_%s.chm" % lang)

        contextUtil.handleSuccess(context)
        logger.logPass()
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
