# -*- coding: UTF-8 -*-

from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common
from cbb.business.operate.expansion import config
from cbb.frame.base.config import OCEAN_PROTECT
from cbb.frame.base.config import NEW_DORADO, OCEAN_STOR_MICRO_DEVS
from cbb.frame.base import baseUtil
from utils import Products


def getItems(context):
    '''
    @summary: 高端扩硬盘框场景获取扩容注意事项的内容
    '''

    try:
        logger = common.getLogger(context.get("logger"), __file__)
        lang = contextUtil.getLang(context)

        deepth = contextUtil.getItem(context, "deepth")
        productModel = contextUtil.getItem(context, "productModel")

        makesureItems = get_notice_item(context, lang)

        if contextUtil.getItem(context, "support4UDiskEnclosure", False):
            makesureItems.append(common.getRes(lang, "suggest_2u_and_4u_not_mixed_sam_loop", (deepth, deepth)))

        # 硬盘框组网上电提示
        makesureItems.append(common.getRes(lang, "clusterConnection_poweron_enc"))

        # 拔插SAS线缆注意事项
        makesureItems.append(common.getRes(lang, "remove.sas.cable.notice"))

        # 切换SAS线缆注意事项
        append_move_sas_to_port_notice(lang, makesureItems, productModel)

        append_move_sas_to_enclosure_notice(lang, makesureItems, productModel)

        jsonArray = []
        for item in makesureItems:
            jsonArray.append('{"title":"%s"}' % item)
        context["retData"] = "[%s]" % ",".join(jsonArray)

        contextUtil.handleSuccess(context)
        logger.logPass()
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return


def append_move_sas_to_port_notice(lang, makesure_items, product_model):
    if baseUtil.is_computing_dev(product_model):
        makesure_items.append(common.getRes(lang, "move.sas.to.other.port.operation.interval.notice_compute"))
    else:
        makesure_items.append(common.getRes(lang, "move.sas.to.other.port.operation.interval.notice1"))


def append_move_sas_to_enclosure_notice(lang, makesure_items, product_model):
    # 二级存储和Dorado 2000不支持智能框
    if product_model in OCEAN_PROTECT or baseUtil.is_dorado_2000(product_model):
        makesure_items.append(common.getRes(lang, "move.sas.to.other.enclosure.operation.interval.notice_sas"))
    elif baseUtil.is_computing_dev(product_model):
        makesure_items.append(common.getRes(lang, "move.sas.to.other.enclosure.operation.interval.notice_compute"))
    else:
        makesure_items.append(common.getRes(lang, "move.sas.to.other.enclosure.operation.interval.notice1"))


def get_notice_item(context, lang):
    """
    获取注意事项
    :param context: 上下文
    :param lang: lang语言
    :return:
    """

    deepth = contextUtil.getItem(context, "deepth")
    smart_depth = contextUtil.getItem(context, "smart_depth")
    product_model = contextUtil.getItem(context, "productModel")
    product_version = contextUtil.getItem(context, "productVersion")
    has_enclosure_redundant = contextUtil.getItem(
        context, "hasEnclosureRedundant", False)

    items = []
    if product_model in OCEAN_PROTECT and Products.compareVersion(product_version, "1.1.0") >= 0:
        sas_deepth = config.OCEAN_PROTECT_MAX_CASCADING_DEPTH.get(product_model, {}).get("SAS")
        items.append(common.getRes(lang, "suggest_cascadeConnection_deepth3", (sas_deepth, sas_deepth)))
    elif product_model in NEW_DORADO + OCEAN_STOR_MICRO_DEVS:
        inter_product_model = common.getInternalProductModel(context)
        items.append(common.get_notice_item_new_dorado(config.NEW_OCEANSTOR_AND_MICRO_MAX_CASCADING_DEPTH,
                                                       product_model, product_version, lang, inter_product_model))
    elif baseUtil.is_computing_dev(product_model):
        items.append(common.getRes(lang, "suggest_cascadeConnection_deepth_compute", (4, 4)))
    elif common.isDorado(product_model):
        # Dorado扩大规格后级联深度为3，其余为2
        cur_depth = 3 if common.is_expansion_spec_dorado_dev(context) else 2
        items.append(common.getRes(lang, "suggest_cascadeConnection_deepth3", (cur_depth, cur_depth)))
        if has_enclosure_redundant:
            items.append(common.getRes(lang, "suggest_has_smart_and_enclosure_redundant"))
    elif product_model in config.V5R8C00_MAX_CASCADING_DEPTH.keys():
        common.set_notice_item(items, config.V5R8C00_MAX_CASCADING_DEPTH, product_model, lang)

    elif not contextUtil.getItem(context, "support4UDiskEnclosure", False):
        # IP后端组网，提示智能硬盘框
        if contextUtil.getItem(context, "daeEnclosureType") == "SMART":
            items.append(common.getRes(lang, "suggest_cascadeConnection_deepth_ip", (smart_depth, smart_depth)))
        # 普通SAS组网，提示2U框
        else:
            items.append(common.getRes(lang, "suggest_cascadeConnection_deepth1", (deepth, deepth)))

    else:
        if deepth == "" or deepth is None:
            # 查询级联深度为空时显示最大级联深度规格
            deepth = '4'
        u4_limit = int(deepth) / 2
        if u4_limit == 0:
            items.append(common.getRes(lang, "suggest_cascadeConnection_deepth1", (deepth, deepth)))
        else:
            items.append(common.getRes(lang, "suggest_cascadeConnection_deepth", (deepth, deepth, str(u4_limit))))

    return items
