# -*- coding: UTF-8 -*-

from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common
from cbb.business.operate.expansion import config
from cbb.frame.base.config import OCEAN_PROTECT
from cbb.frame.base.config import NEW_DORADO, OCEAN_STOR_MICRO_DEVS
from cbb.frame.base import baseUtil
from utils import Products


def getItems(context):
    '''
    @summary: 高端扩硬盘框场景获取扩容注意事项的内容
    '''

    logger = common.getLogger(context.get("logger"), __file__)
    try:
        lang = contextUtil.getLang(context)
        productModel = contextUtil.getItem(context, "productModel")
        has_enclosure_redundant = contextUtil.getItem(
            context, "hasEnclosureRedundant", False)
        product_version = contextUtil.getItem(context, "productVersion")

        makesureItems = []
        if productModel in config.V5R8C00_MAX_CASCADING_DEPTH.keys():
            common.set_notice_item(
                makesureItems, config.V5R8C00_MAX_CASCADING_DEPTH,
                productModel, lang)
        elif productModel in NEW_DORADO  + OCEAN_STOR_MICRO_DEVS:
            makesureItems.append(
                common.get_notice_item_new_dorado(config.NEW_OCEANSTOR_AND_MICRO_MAX_CASCADING_DEPTH, productModel,
                                                  product_version, lang, common.getInternalProductModel(context)))
        elif baseUtil.is_computing_dev(productModel):
            makesureItems.append(
                common.getRes(lang, "suggest_cascadeConnection_deepth_compute", (4, 4)))
        elif productModel in OCEAN_PROTECT and Products.compareVersion(
                product_version, "1.1.0") >= 0:
            sas_deepth = config.OCEAN_PROTECT_MAX_CASCADING_DEPTH.get(
                productModel, {}).get("SAS")
            makesureItems.append(common.getRes(
                lang, "suggest_cascadeConnection_deepth3",
                (sas_deepth, sas_deepth)))
        else:
            makesureItems.append(
                common.getRes(lang, "suggest_cascadeConnection_deepth3", (2, 2)))

        if has_enclosure_redundant:
            makesureItems.append(
                common.getRes(lang,
                              "suggest_has_smart_and_enclosure_redundant"))

        makesureItems.append(
            common.getRes(lang, "suggest_connectSasCableBaseOnGuide"))

        # 硬盘框组网上电提示
        makesureItems.append(common.getRes(lang, "clusterConnection_poweron_encForDorado"))

        # 拔插SAS线缆注意事项
        append_move_sas_to_port_notice(lang, makesureItems, productModel)
        # 切换SAS线缆到其他框注意事项。
        append_move_sas_to_enclosure_notice(lang, makesureItems, productModel)

        jsonArray = []
        for item in makesureItems:
            jsonArray.append('{"title":"%s"}' % item)
        context["retData"] = "[%s]" % ",".join(jsonArray)

        contextUtil.handleSuccess(context)
        logger.logPass()
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return


def append_move_sas_to_enclosure_notice(lang, makesure_items, product_model):
    # 二级存储和Dorado 2000不支持智能框
    if product_model in OCEAN_PROTECT or baseUtil.is_dorado_2000(product_model):
        makesure_items.append(common.getRes(lang, "move.sas.to.other.enclosure.operation.interval.notice_sas"))
    elif baseUtil.is_computing_dev(product_model):
        makesure_items.append(common.getRes(lang, "move.sas.to.other.enclosure.operation.interval.notice_compute"))
    else:
        makesure_items.append(common.getRes(lang, "move.sas.to.other.enclosure.operation.interval.notice1"))


def append_move_sas_to_port_notice(lang, makesure_items, product_model):
    if baseUtil.is_computing_dev(product_model):
        makesure_items.append(common.getRes(lang, "move.sas.to.other.port.operation.interval.notice_compute"))
    else:
        makesure_items.append(common.getRes(lang, "move.sas.to.other.port.operation.interval.notice1"))
