# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2023. All rights reserved.

"""
@time: 2019/09/11
@file: post_check_alarms.py
@function: 更换后检查系统告警
@modify:
"""

from cbb.frame.base import funcUtils
from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common
from cbb.common.dev.utils import skipAlarmCheck
import time

from expandDisk.common import checkSysAlarms

WAIT_TIME = 450  # (解决"告警5分钟之后才上报"的问题) 等待时间6分钟 + 检测时间90s


def execute(context, param=0):
    """扩容后检查告警

    :param context:
    :param param:
    :return:
    """
    logger = common.getLogger(context.get("logger"), __file__)
    contextUtil.setItem(context, "totalReaminTime", WAIT_TIME)
    context["curRemainTime"] = WAIT_TIME
    while context["curRemainTime"] >= 120:
        common.setExpansionProgress(context, True)
        time.sleep(1)
        context["curRemainTime"] -= 1
    try:
        if skipAlarmCheck():
            logger.logInfo(
                "run in developer mode, skip alarm check directly..")
            contextUtil.handleSuccess(context)
            return

        checkSysAlarms.execute(context, param=90)

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
    finally:
        context["curRemainTime"] = 0
        common.setExpansionProgress(context, True)
