# -*- coding: UTF-8 -*-

from cbb.business.operate.expansion import common
from cbb.frame.context import contextUtil
from cbb.frame.base.config import NEW_DORADO


def initDevGraph(context):
    """
    确认摆放位置步骤绘制设备图
    :param context:
    :return:
    """
    if is_full_bay_dorado(context):
        import cbb.frame.devGraph.dorodaoV6HighEndGraphUtil as graphUtil
    else:
        import cbb.frame.devGraph.graphUtil as graphUtil

    logger = common.getLogger(context.get("logger"), __file__)

    logger.logInfo("draw devGraph")
    graphUtil.refreshGraph(context, isBack=False)
    graphUtil.light_new_disk_enclosure(context)

    contextUtil.handleSuccess(context)
    logger.logPass()
    return


def is_full_bay_dorado(context):
    """
    是否是整柜交付的Dorado设备（不包含新融合）
    :param context:
    :return:
    """
    product_model = contextUtil.getItem(context, "productModel")
    return contextUtil.getItem(context, 'isFullBayDeliverPdt', False) \
        and contextUtil.getItem(context, "isDorado", False) \
        and product_model not in NEW_DORADO
