# -*- coding: UTF-8 -*-

from cbb.business.operate.expansion import common
from cbb.frame.context import contextUtil
from cbb.frame.devGraph import graphUtil
from cbb.business.operate.expansion import config


def initDevGraph(context):
    """线缆连接步骤绘制设备图

    :param context:
    :return:
    """
    logger = common.getLogger(context.get("logger"), __file__)
    lang = contextUtil.getLang(context)
    
    logger.logInfo("draw devGraph")
    graphUtil.lightNewDiskEnclosures(context)

    deepth = contextUtil.getItem(context, "deepth")
    smart_depth = contextUtil.getItem(context, "smart_depth")
    # 新融合混闪场景，智能级联深度为1
    inter_product_model = common.getInternalProductModel(context)
    if inter_product_model in config.INTER_PRODUCT_MODEL_SUPPORT_FLASHING:
        smart_depth = 1
    support_4u_disk_enc = contextUtil.getItem(context,
                                              "support4UDiskEnclosure",
                                              False)

    sas_enc_num, smart_enc_num = common.get_expand_enc_num(context)
    # 支持4U，但没有扩智能框
    if support_4u_disk_enc and smart_enc_num == 0:
        if not deepth:
            deepth = '4'
        u4Limit = int(deepth) / 2
        msg = common.getRes(lang, "connectLineMsg_deep_refresh",
                            (deepth, deepth, str(u4Limit)))

    else:
        # 既有智能框，又有SAS框,不做提示
        if sas_enc_num > 0 and smart_enc_num > 0:
            msg = ""
        # 提示智能硬盘框
        elif is_expand_smart_enc(context, smart_enc_num, inter_product_model):
            msg = common.getRes(lang, "connectLineMsg_deep1_refresh_ip",
                                (smart_depth, smart_depth))
        # 提示2U框
        else:
            msg = common.getRes(lang, "connectLineMsg_deep1_refresh",
                                (deepth, deepth))
    
    resultList = []
    errMsg = {"connectLine.message": msg}
    resultList.extend([errMsg])
    context["refreshData"] = common.dictList2JsonArray(resultList)

    newEnc2UList = contextUtil.getItem(context, "newEnc2UList")
    newEnc4UList = contextUtil.getItem(context, "newEnc4UList")
    logger.logInfo('newEnc2UList:' + str(newEnc2UList))
    logger.logInfo('newEnc4UList:' + str(newEnc4UList))
    
    # 记录用户行为数据
    contextUtil.appendUserOpData(context,
                                 config.UserOpDataFields.EXPANSION_TYPE_BAY)
    
    contextUtil.handleSuccess(context)
    logger.logPass()
    return


def is_expand_smart_enc(context, smart_enc_num, inter_product_model):
    """
    判断是否只扩智能硬盘框
    :param context: 上下文
    :param smart_enc_num: 智能框数量
    :param inter_product_model: 内部型号
    :return:
    """
    return any([contextUtil.getItem(context, "daeEnclosureType") == "SMART",
                smart_enc_num > 0,
                inter_product_model in config.INTER_PRODUCT_MODEL_SUPPORT_NVME])
