# -*- coding: UTF-8 -*-

from cbb.business.operate.expansion import common
from cbb.business.operate.expansion import config
from cbb.frame.context import contextUtil
from cbb.frame.devGraph import dorodaoV6HighEndGraphUtil
from cbb.frame.tlv import tlvUtil


def initDevGraph(context):
    logger = common.getLogger(context.get("logger"), __file__)
    lang = contextUtil.getLang(context)
    
    logger.logInfo("draw devGraph")
    dorodaoV6HighEndGraphUtil.refreshGraph(context, isBack=False)
    dorodaoV6HighEndGraphUtil.highLightNewDiskBayOrDae(context)

    deepth = contextUtil.getItem(context, "deepth")
    # Dorado扩大规格后级联深度为3
    if common.is_expansion_spec_dorado_dev(context):
        deepth = 3
    msg = common.getRes(lang, "connectLineMsg_deep1_refresh", (deepth, deepth))

    resultList = []
    errMsg = {"connectLine.message":msg}
    resultList.extend([errMsg])
    context["refreshData"] = common.dictList2JsonArray(resultList)

    # 通知升级模块硬盘框并发升级（在新扩硬盘框上电前通知）
    tlv = contextUtil.getTlv(context)
    newDaes =contextUtil.getItem(context, 'doradoV6HighEndNewDaes', [])
    tlvUtil.notifyEnclosureConcurrentUpgrade(tlv, len(newDaes), logger)
    
    #记录用户行为数据
    contextUtil.appendUserOpData(context, config.UserOpDataFields.EXPANSION_TYPE_BAY)
    
    contextUtil.handleSuccess(context)
    logger.logPass()
    return

