# -*- coding: UTF-8 -*-

from cbb.business.operate.expansion import common
from cbb.frame.context import contextUtil


def initDevGraph(context):
    """线缆检测绘制设备图

    :param context:
    :return:
    """
    logger = common.getLogger(context.get("logger"), __file__)

    logger.logInfo("draw devGraph")
    if contextUtil.getItem(context, 'isFullBayDeliverPdt', False) \
            and contextUtil.getItem(context, "isDorado", False):
        from cbb.frame.devGraph.dorodaoV6HighEndGraphUtil import drawGraph \
            as drawGraph
    else:
        from cbb.frame.devGraph.graphUtil import drawGraphForExp as drawGraph

    drawGraph(context, {"isBack": True})

    contextUtil.handleSuccess(context)
    logger.logPass()
    return
