# -*- coding: UTF-8 -*-

from cbb.business.operate.expansion import common
from cbb.frame.context import contextUtil


def initDevGraph(context):
    """加入系统步骤绘制设备图

    :param context: 上下文
    :return:
    """
    logger = common.getLogger(context.get("logger"), __file__)
    if contextUtil.getItem(context, 'isFullBayDeliverPdt', False) \
            and contextUtil.getItem(context, "isDorado", False):
        from cbb.frame.devGraph.dorodaoV6HighEndGraphUtil import drawGraph \
            as drawGraph
    else:
        from cbb.frame.devGraph.graphUtil import drawGraphForExp as drawGraph

    logger.logInfo("draw devGraph")
    drawGraph(context, {"isBack": True})
    
    contextUtil.handleSuccess(context)
    logger.logPass()
    return
