# -*- coding: UTF-8 -*-

from cbb.business.operate.expansion.enclosure.v5HighEnd import fullBayFuncUtils
from cbb.business.operate.expansion import common
from cbb.frame.context import contextUtil
from cbb.frame.devGraph import graphUtil
from cbb.business.operate.expansion import jsonUtil
from cbb.business.operate.expansion import tableItemsUtilForV5HighEnd


def refreshData(context, param):
    """刷新2U硬盘框的数据

    :param context:
    :param param:
    :return:
    """
    logger = common.getLogger(context.get("logger"), __file__)
    try:
        changedId = context.get("input_changed_id")  # 当前触发的控件id
        logger.logInfo("input_changed_id: %s" % changedId)

        enclosureNum = int(context.get(changedId))  # 获取硬盘框的数量
        logger.logInfo("input 2U enlosure number: %d" % enclosureNum)

        # 获取新增框的信息列表
        height = 2  # 2U硬盘框
        rowId = changedId.split("_")[1]  # 上下文获取到的格式为stepId_rowId_colId
        cabinetName = contextUtil.getCabinetNameInRow(context, rowId)
        newEnc2UList = fullBayFuncUtils.get_new_enclosures(context,
                                                           cabinetName,
                                                           enclosureNum,
                                                           height)
        logger.logInfo("newEnc2UList:%s" % str(newEnc2UList))

        contextUtil.setItem(context, "newCabinetInfoDict",
                            common.getNewCabinetInfoFor2UEnc(context,
                                                             newEnc2UList,
                                                             cabinetName))
        contextUtil.updateSelectedConfig(context, rowId, "newEnc2UList",
                                         newEnc2UList)
        contextUtil.updateEclosures(context)

        # 判断该机柜是否重复选择配置
        selectedCabinets = contextUtil.getItem(context, "selectedCabinets")
        if selectedCabinets.count(cabinetName) >= 2:
            executeWhenSameCabinet(context, cabinetName, changedId)
        else:
            executeWhenDiffCabinet(context, cabinetName, changedId)

        # 更新设备图
        encGraphInfoList = common.createEncGraphInfo(context)
        logger.logInfo("encGraphInfoList:%s" % str(encGraphInfoList))
        contextUtil.setItem(context, "encGraphInfoList", encGraphInfoList)
        graphUtil.refreshGraph(context, isBack=False)

        contextUtil.handleSuccess(context)
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return


def executeWhenSameCabinet(context, cabinetName, changedId):
    """刷新机柜的数据

    :param context: 上下文
    :param cabinetName: 机柜名
    :param changedId: 触发的控件ID
    :return:
    """
    logger = common.getLogger(context.get("logger"), __file__)
    logger.logInfo("select same cabinet")

    itemIds = changedId.split("_")  # 上下文获取到的格式为stepId_rowId_colId
    colId = itemIds[-1]
    refreshColId = int(colId) + 1
    refreshItemKey = 'return_%d' % refreshColId
    logger.logInfo("refresh id = %s" % refreshItemKey)
    # 联动2U硬盘框
    newItem = {
        "rule": '0',
        "default": "0"
    }

    refreshValue = jsonUtil.dict2JsonStr(newItem)
    context[refreshItemKey] = refreshValue
    return


def executeWhenDiffCabinet(context, cabinetName, changedId):
    """刷新机柜的数据

    :param context: 上下文
    :param cabinetName: 机柜名
    :param changedId: 触发的控件ID
    :return:
    """
    logger = common.getLogger(context.get("logger"), __file__)
    logger.logInfo("select different cabinet")

    dae_enc_type = contextUtil.getItem(context, "daeEnclosureType")
    support_sas_nvme_mix = contextUtil.getItem(context,
                                               "supportSASandNVMeMix", False)

    itemIds = changedId.split("_")  # 上下文获取到的格式为stepId_rowId_colId
    colId = itemIds[-1]
    refreshColId = int(colId) + 1
    refreshItemKey = 'return_%d' % refreshColId

    # 联动4U硬盘框
    curEncHeight = 4

    newRule = tableItemsUtilForV5HighEnd.getEnclosureRule(context, cabinetName,
                                                          curEncHeight)
    logger.logInfo("the new rule for %sU enclosure: %s" % (str(curEncHeight),
                                                           newRule))
    newItem = {
        "rule": newRule,
        "default": "0"
    }

    refreshValue = jsonUtil.dict2JsonStr(newItem)
    context[refreshItemKey] = refreshValue

    if support_sas_nvme_mix:
        # 联动2U NVME硬盘框
        refreshColId = int(colId) + 2
        refreshItemKey = 'return_%d' % refreshColId

        curEncHeight = 3
        newRule = tableItemsUtilForV5HighEnd.getEnclosureRule(context,
                                                              cabinetName,
                                                              curEncHeight)
        logger.logInfo("the new rule for 2U NVMe enclosure: %s" % newRule)
        newItem = {
            "rule": newRule,
            "default": "0"
        }

        refreshValue = jsonUtil.dict2JsonStr(newItem)
        context[refreshItemKey] = refreshValue
    return
