#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2020. All rights reserved.

"""
@version: Toolkit V200R006C00
@time: 2020/08/14
@file: select2UNVMeEnclosure.py
@function:
@modify:
"""
from cbb.business.operate.expansion.enclosure.v5HighEnd import fullBayFuncUtils
from cbb.business.operate.expansion import common
from cbb.frame.context import contextUtil
from cbb.frame.devGraph import graphUtil


def refreshData(context, param):
    """刷新2UNVMe硬盘框的数据

    :param context:
    :param param:
    :return:
    """
    logger = common.getLogger(context.get("logger"), __file__)
    try:
        changedId = context.get("input_changed_id")  # 当前触发的控件id
        logger.logInfo("input_changed_id: %s" % changedId)

        enclosureNum = int(context.get(changedId))  # 获取硬盘框的数量
        logger.logInfo("input 2U NVMe enlosure number: %d" % enclosureNum)

        # 获取新增框的信息列表
        height = 3  # 针对2UNVMe硬盘框
        rowId = changedId.split("_")[1]  # 上下文获取到的格式为stepId_rowId_colId
        cabinetName = contextUtil.getCabinetNameInRow(context, rowId)
        newEnc2UNVMeList = fullBayFuncUtils.get_new_enclosures(context,
                                                               cabinetName,
                                                               enclosureNum,
                                                               height)
        logger.logInfo("newEnc2U_NVMeList:%s" % str(newEnc2UNVMeList))
        contextUtil.updateSelectedConfig(context, rowId, "newEnc2UNVMeList",
                                         newEnc2UNVMeList)
        contextUtil.updateEclosures(context)

        # 更新设备图
        encGraphInfoList = common.createEncGraphInfo(context)
        logger.logInfo("encGraphInfoList:%s" % str(encGraphInfoList))
        contextUtil.setItem(context, "encGraphInfoList", encGraphInfoList)
        graphUtil.refreshGraph(context, isBack=False)

        contextUtil.handleSuccess(context)
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
