# -*- coding: UTF-8 -*-

from cbb.business.operate.expansion import common
from cbb.frame.context import contextUtil
from cbb.frame.devGraph import graphUtil
from cbb.business.operate.expansion import jsonUtil
from cbb.business.operate.expansion import tableItemsUtilForV5HighEnd


def refreshData(context, param):
    """刷新机柜的数据

    :param context:
    :param param:
    :return:
    """
    logger = common.getLogger(context.get("logger"), __file__)
    try:
        changedId = context.get("input_changed_id")  # 当前触发的控件id
        logger.logInfo("input_changed_id: %s" % changedId)

        cabinetName = context.get(changedId)  # 获取硬盘柜名称
        logger.logInfo("input cabinet name: %s" % cabinetName)

        # 判断该机柜是否已经完成配置
        checkResult = common.checkSameCabinetCofig(context, cabinetName)
        logger.logInfo("check same cabinet result:%s" % str(checkResult))
        if not checkResult:
            executeWhenSameCabinet(context, cabinetName, changedId)
            contextUtil.handleSuccess(context)
            return
        else:
            executeWhenDiffCabinet(context, cabinetName, changedId)

        # 更新选择的柜名
        itemIds = changedId.split("_")  # 上下文获取到的格式为stepId_rowId_colId
        rowId = itemIds[1]
        contextUtil.updateSelectedConfig(context, rowId, "cabinetName",
                                         cabinetName)

        # 更新已选柜列表
        contextUtil.updateSelectedCabinets(context)
        contextUtil.updateNewBayList(context)
        # 更新设备图
        graphUtil.refreshGraph(context, isBack=False)

        encGraphInfoList = common.createEncGraphInfo(context)
        logger.logInfo("encGraphInfoList:%s" % str(encGraphInfoList))
        contextUtil.setItem(context, "encGraphInfoList", encGraphInfoList)
        graphUtil.refreshGraph(context, isBack=False)

        contextUtil.handleSuccess(context)
        return
    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return


def executeWhenSameCabinet(context, cabinetName, changedId):
    """相同柜时提示框

    :param context: 上下文
    :param cabinetName: 机柜名
    :param changedId: 控件ID
    :return:
    """
    logger = common.getLogger(context.get("logger"), __file__)
    lang = contextUtil.getLang(context)
    logger.logInfo("select same cabinet")

    # 弹出提示框
    dialogUtil = context.get("dialogUtil")
    errMsg = common.getRes(lang, "exist_same_cabinet")
    nextProc = dialogUtil.showInfoDialog(errMsg)
    context["nextProc"] = nextProc
    context["remind"] = True
    context["isRefresh"] = False  # 是否需要刷新为当前值
    return


def executeWhenDiffCabinet(context, cabinetName, changedId):
    """选择不同框时刷新机柜的数据

    :param context: 上下文
    :param cabinetName: 机柜名
    :param changedId: 控件ID
    :return:
    """
    logger = common.getLogger(context.get("logger"), __file__)
    logger.logInfo("select different cabinet")

    dae_enc_type = contextUtil.getItem(context, "daeEnclosureType")
    support_sas_nvme_mix = contextUtil.getItem(context,
                                               "supportSASandNVMeMix", False)

    itemIds = changedId.split("_")  # 上下文获取到的格式为stepId_rowId_colId
    colId = itemIds[-1]

    # 联动2U硬盘框
    refresh2UColId = int(colId) + 1
    refresh2UItemKey = 'return_%d' % refresh2UColId
    curEncHeight = 2  # 联动2U硬盘框
    newRule = tableItemsUtilForV5HighEnd.getEnclosureRule(context, cabinetName,
                                                          curEncHeight)
    logger.logInfo("the new rule for 2U enclosure: %s" % newRule)
    newItem = {
        "rule": newRule,
        "default": ""
    }

    refresh2UValue = jsonUtil.dict2JsonStr(newItem)
    context[refresh2UItemKey] = refresh2UValue

    # 联动4U硬盘框
    itemIds = changedId.split("_")  # 上下文获取到的格式为stepId_rowId_colId
    colId = itemIds[-1]
    refreshColId = int(colId) + 2
    refreshItemKey = 'return_%d' % refreshColId

    if dae_enc_type == "SMART":
        # 联动2U NVMe框
        curEncHeight = 3
    else:
        # 联动4U硬盘框
        curEncHeight = 4

    newRule = tableItemsUtilForV5HighEnd.getEnclosureRule(context, cabinetName,
                                                          curEncHeight)
    logger.logInfo("the new rule for %sU enclosure: %s" % (str(curEncHeight),
                                                           newRule))
    newItem = {
        "rule": newRule,
        "default": "0"
    }

    refreshValue = jsonUtil.dict2JsonStr(newItem)
    context[refreshItemKey] = refreshValue

    if support_sas_nvme_mix and not dae_enc_type == "SMART":
        # 联动2U NVME硬盘框
        refreshColId = int(colId) + 3
        refreshItemKey = 'return_%d' % refreshColId

        curEncHeight = 3
        newRule = tableItemsUtilForV5HighEnd.getEnclosureRule(context,
                                                              cabinetName,
                                                              curEncHeight)
        logger.logInfo("the new rule for 2U NVMe enclosure: %s" % newRule)
        newItem = {
            "rule": newRule,
            "default": "0"
        }

        refreshValue = jsonUtil.dict2JsonStr(newItem)
        context[refreshItemKey] = refreshValue
    return
