# -*- coding: UTF-8 -*-

from cbb.frame.context import contextUtil
from cbb.frame.devGraph import graphUtil
from cbb.business.operate.expansion import common
from cbb.business.operate.expansion import tableItemsUtilForV5HighEnd
from cbb.business.operate.expansion.enclosure.v5HighEnd import fullBayFuncUtils


def initDevGraph(context):
    """初始化设备图

    :param context:
    :return:
    """
    logger = common.getLogger(context.get("logger"), __file__)
    # 绘制设备图
    graphUtil.drawGraphForExp(context, {"isBack": False})

    logger.logInfo("initial devices graph success")
    contextUtil.handleSuccess(context)
    return


def init(context):
    """初始化界面配置数据，初始化时列表中只显示一行数据，
        需要多行数据可以使用界面”添加“按钮

    :param context:
    :return:
    """
    tableItems = []
    logger = common.getLogger(context.get("logger"), __file__)
    # 从连接线缆步骤返回上一步来重新配置时，需要重置已保存的配置信息
    fullBayFuncUtils.clear_selected_config(context)

    # 表头配置数据
    tableHeadItem = tableItemsUtilForV5HighEnd.getTableRowItem(context)
    tableItems.append(tableHeadItem)

    # 第一行数据
    rowId = 1
    # 记录当前行数，作为记录每行数据key
    contextUtil.setItem(context, "curRow", rowId)
    firstColItem = tableItemsUtilForV5HighEnd.getTableRowItem(context, rowId)
    tableItems.append(firstColItem)
    logger.logInfo("tableItems:%s" % str(tableItems))

    # 更新初始化新增柜数据
    contextUtil.updateNewBayList(context)

    # 设置初始化项目
    contextUtil.setTableItemInit(context, tableItems)
    contextUtil.handleSuccess(context)
    return


def addRow(context):
    """ 点击“添加”按钮，新增一行数据

    :param context: 上下文
    :return:
    """
    resultDict = {"flag": True, "errMsg": "", "suggestion": ""}
    logger = common.getLogger(context.get("logger"), __file__)
    lang = contextUtil.getLang(context)
    availableCabinets = contextUtil.getItem(context, "availableCabinets")
    logger.logInfo("available cabinets:%s" % str(availableCabinets))
    if len(availableCabinets) == 0:
        resultDict["flag"] = False
        resultDict["errMsg"], resultDict["suggestion"] = \
            common.getMsg(lang, "add.item.error")
        contextUtil.handleFailure(context, resultDict)
        return

    rowNum = contextUtil.getItem(context, "curRow")
    rowId = rowNum + 1  # 新增一行
    logger.logInfo("Add a row:%s" % str(rowId))
    contextUtil.setItem(context, "curRow", rowId)  # 更新行数

    rowItems = tableItemsUtilForV5HighEnd.getTableRowItem(context, rowId)
    logger.logInfo("rowItems:%s" % str(rowItems))
    contextUtil.setNewRowItem(context, rowItems)

    # 更新已选柜列表
    contextUtil.updateNewBayList(context)

    # 更新柜设备图
    graphUtil.refreshGraph(context, isBack=False)

    # 更新框设备图
    encGraphInfoList = common.createEncGraphInfo(context)
    logger.logInfo("encGraphInfoList:%s" % str(encGraphInfoList))
    contextUtil.setItem(context, "encGraphInfoList", encGraphInfoList)
    graphUtil.refreshGraph(context, isBack=False)

    contextUtil.handleSuccess(context)
    logger.logInfo("add data success 2")
    return


def delRow(context, rowKey):
    """删除一行数据

    :param context:
    :param rowKey:
    :return:
    """
    logger = common.getLogger(context.get("logger"), __file__)
    logger.logInfo("delete data of row [%s]" % str(rowKey))

    # 更新配置数据
    contextUtil.deleteSelectedConfigByRow(context, rowKey)
    contextUtil.updateEclosures(context)
    contextUtil.updateSelectedCabinets(context)
    contextUtil.updateNewBayList(context)  # 更新已选柜列表
    # 更新设备图
    encGraphInfoList = common.createEncGraphInfo(context)
    logger.logInfo("encGraphInfoList:%s" % str(encGraphInfoList))
    contextUtil.setItem(context, "encGraphInfoList", encGraphInfoList)

    graphUtil.refreshGraph(context, isBack=False)
    contextUtil.handleSuccess(context)
    return


def saveData(context):
    """保存配置数据：暂时未用

    :param context:
    :return:
    """
    contextUtil.handleSuccess(context)
    return


def verifyData(context):
    """验证配置数据：点击”下一步“，则会调用该方法

    :param context:
    :return:
    """
    logger = common.getLogger(context.get("logger"), __file__)
    logger.logInfo("start verify data")
    verifyResult = common.verifyConfig(context)
    logger.logInfo("verifyData result:%s" % str(verifyResult))
    if not verifyResult[0]:
        context["failItems"] = ','.join(verifyResult[1])
        context["errorCabinets"] = ', '.join(verifyResult[2])
        context["verifySucc"] = False
        return

    context["verifySucc"] = True
    return


def verifyFailed(context):
    """标记已验证失败的数据行

    :param context:
    :return:
    """
    logger = common.getLogger(context.get("logger"), __file__)
    lang = contextUtil.getLang(context)

    dialogUtil = context.get("dialogUtil")
    errorCabinets = context.get("errorCabinets")
    logger.logInfo("error cabinets:%s" % errorCabinets)

    if len(errorCabinets) == 0:
        # 无配置信息
        context["failItems"] = ""
        errMsg = common.getRes(lang, "donot_add_enclosure_config")
    else:
        errMsg = common.getRes(lang, "verify_item_failed", errorCabinets)
    nextProc = dialogUtil.showInfoDialog(errMsg)
    context["nextProc"] = nextProc
    return
