# -*- coding: UTF-8 -*-

import json

from cbb.business.operate.expansion import common
from cbb.business.operate.expansion import tableItemsUtil
from cbb.frame.context import contextUtil
from cbb.frame.devGraph import dorodaoV6HighEndGraphUtil

COLUMN_NUMBER = 1  # 四列数据
# 新增智能硬盘框超过20个，智能硬盘框可能接入失败
SMART_ENCLOSURE_MAX_NUM = 20
SMART_TYPE = "SMART"

def initDevGraph(context):
    """Initializing device graph when loading this step.

    :param context:
    :return:
    """
    logger = common.getLogger(context.get("logger"), __file__)
    # 绘制设备图
    dorodaoV6HighEndGraphUtil.drawGraph(context, {"isBack": False})

    logger.logInfo("initial devices graph success")
    contextUtil.handleSuccess(context)
    return


def init(context):
    """初始化界面配置数据，初始化时列表中只显示一行数据，需要多行数据可以使用界面”添加“按钮

    :param context:
    :return:
    """
    rows = []
    logger = common.getLogger(context.get("logger"), __file__)

    lang = contextUtil.getLang(context)
    label = common.getRes(lang, "dorado_v6_newly_add_dae_number")
    expandType = contextUtil.getItem(context, "expandType")
    itemScript = tableItemsUtil.COLUMN_ITEM_SCRIPT.get(
        expandType, {}).get('0')
    maxSupportNewDiskEncNum = contextUtil.getItem(
        context, "maxSupportNewDiskEncNum", 0
    )
    daeNumRule = ','.join(map(str, range(maxSupportNewDiskEncNum + 1)))

    inputRow = tableItemsUtil.createInputItemPairsForDoradoV6(labelColumnIdx=0,
                                                              label=label,
                                                              scriptFile=itemScript,
                                                              rule=daeNumRule)
    context["retData_init"] = json.dumps(inputRow)
    logger.logInfo("retData_init:%s" % context["retData_init"])

    # 更新初始化新增柜数据
    contextUtil.updateNewBayList(context)

    contextUtil.handleSuccess(context)
    return


def saveData(context):
    """保存配置数据：暂时未用

    :param context:
    :return:
    """
    contextUtil.handleSuccess(context)
    return


def verifyData(context):
    """验证配置数据：点击”下一步“，则会调用该方法

    :param context:
    :return:
    """
    logger = common.getLogger(context.get("logger"), __file__)
    logger.logInfo("start verify data")
    recommendDaes = contextUtil.getItem(context, 'doradoV6HighEndNewDaes', None)
    logger.logInfo("verifyData result:%s" % str(recommendDaes))
    if not recommendDaes:
        context["verifySucc"] = False
        return

    context["verifySucc"] = True
    return


def verifyFailed(context):
    """标记已验证失败的数据行

    :param context:
    :return:
    """
    logger = common.getLogger(context.get("logger"), __file__)
    lang = contextUtil.getLang(context)

    dialogUtil = context.get("dialogUtil")
    errorCabinets = context.get("errorCabinets")
    logger.logInfo("error cabinets:%s" % errorCabinets)

    if errorCabinets is None or not errorCabinets:
        # 无配置信息
        context["failItems"] = ""
        errMsg = common.getRes(lang, "dorado_v6_highend_dae_num_cannot_be_zero")
    else:
        errMsg = common.getRes(lang, "verify_item_failed", errorCabinets)
    nextProc = dialogUtil.showInfoDialog(errMsg)
    context["nextProc"] = nextProc
    return
