# -*- coding: UTF-8 -*-
from cbb.business.operate.expansion import common
from cbb.business.operate.expansion.enclosure.v6HighEnd.recommendDae import recommendDaes
from cbb.common.query.hardware.enclosure import getOriginalDaeNamesByLocs
from cbb.frame.context import contextUtil
from cbb.frame.devGraph import dorodaoV6HighEndGraphUtil


def refreshData(context, param=None):
    """Refresh device graph when user selecting the number of expansion disk enclosure.

    :param context:
    :param param:
    :return:
    """
    logger = common.getLogger(context.get("logger"), __file__)
    try:

        changedId = context.get("input_changed_id")  # 当前触发的控件id
        logger.logInfo("input_changed_id: %s" % changedId)

        expDaeNum = int(context.get(changedId))  # 获取硬盘框的数量
        logger.logInfo("input disk enclosure number: %d" % expDaeNum)
        oldDaeNumSelected = contextUtil.getItem(context, "oldDaeNumSelected", None)
        if oldDaeNumSelected is not None and expDaeNum == oldDaeNumSelected:
            logger.logInfo("input enclosure number: %d not changed, need not to redraw graph." % expDaeNum)
            contextUtil.handleSuccess(context)
            return

        # 获取新增框的信息列表
        existingBayNames = contextUtil.getItem(context, "oldCabinetNames")
        existingDaelocs = contextUtil.getItem(context, "originDiskEncLocList")

        daeEnclosureType = contextUtil.getItem(context, "daeEnclosureType")
        backendNetMode = contextUtil.getItem(context, "backendNetMode")

        originHardwareGraphInfoList = contextUtil.getItem(context, 'originHardwareGraphInfoList', [])
        existingDaeNames = getOriginalDaeNamesByLocs(existingDaelocs, daeEnclosureType, backendNetMode)

        existingBayNames = [bayDict.get('name') for bayDict in
                            filter(lambda graphInfoDict: graphInfoDict.get('typeName') == 'BAY',
                                   originHardwareGraphInfoList)]

        logger.logInfo("recommend algorithm feed paras, existingBayNames:%s, existingDaeNames:%s"
                       ",expDaeNum:%s, daeEnclosureType:%s, backendNetMode:%s"
                       % (
                           str(existingBayNames), str(existingDaeNames), str(expDaeNum), daeEnclosureType,
                           backendNetMode))
        newDaes = recommendDaes(existingBayNames, existingDaeNames, expDaeNum, daeEnclosureType, backendNetMode,
                                context)
        logger.logInfo("new daes are:%s" % newDaes)

        daesFromNewBay = list(filter(lambda dae: dae.bayName not in existingBayNames, newDaes))
        newBayNames = list(map(lambda dae: dae.bayName, daesFromNewBay))
        logger.logInfo("newBayNames:%s" % str(newBayNames))

        contextUtil.setItem(context, 'doradoV6HighEndNewDaes', newDaes)
        contextUtil.setItem(context, 'newBayList', newBayNames)

        expDaeGraphInfoList = common.createEncGraphInfoForDoradoV6HighEnd(context)
        expBayGraphInfoList = common.createBaysGraph(newBayNames)

        logger.logInfo("expDaeGrapInfoList:%s" % str(expDaeGraphInfoList))
        logger.logInfo("expBayGrapInfoList:%s" % str(expBayGraphInfoList))

        expBayAndDaeGraphInfoList = []
        expBayAndDaeGraphInfoList.extend(expDaeGraphInfoList)
        expBayAndDaeGraphInfoList.extend(expBayGraphInfoList)
        contextUtil.setItem(context, "expBayAndDaeGraphInfoList", expBayAndDaeGraphInfoList)

        dorodaoV6HighEndGraphUtil.refreshGraph(context, False)
        contextUtil.getItem(context, "oldDaeNumSelected", expDaeNum)
        contextUtil.handleSuccess(context)
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
