# -*- coding: UTF-8 -*-

from cbb.business.operate.expansion import common
from cbb.business.operate.expansion import enclosureCommon
from cbb.frame.context import contextUtil
from cbb.frame.devGraph import graphUtil


def refreshData(context, param):
    '''
    @summary: 刷新4U硬盘框的数据
    '''
    try:
        logger = common.getLogger(context.get("logger"), __file__)
        
        changedId = context.get("input_changed_id")    #当前触发的控件id
        logger.logInfo("input_changed_id: %s" % changedId)
        
        enclosureNum = int(context.get(changedId))  #获取硬盘框的数量
        logger.logInfo("input 4U enlosure number: %d" % enclosureNum)
    
        #获取新增框的信息列表
        height = 4  #4U硬盘框
        rowId = changedId.split("_")[1]     #上下文获取到的格式为stepId_rowId_colId
        newCabinetInfoDict = contextUtil.getItem(context, "newCabinetInfoDict")
        cabinetName = contextUtil.getCabinetNameInRow(context, rowId)
        cabinet = newCabinetInfoDict.get(cabinetName)
        newEnc4UList = enclosureCommon.getNewEnclosures(context, cabinet, enclosureNum, height)
        logger.logInfo("newEnc4UList:%s" % str(newEnc4UList))
        contextUtil.updateSelectedConfig(context, rowId, "newEnc4UList", newEnc4UList)
        contextUtil.updateEclosures(context)
    
        #更新设备图
        encGraphInfoList = common.createEncGraphInfo(context)
        logger.logInfo("encGraphInfoList:%s" % str(encGraphInfoList))
        contextUtil.setItem(context, "encGraphInfoList",encGraphInfoList)
        graphUtil.refreshGraph(context,'EXP',False)
        
        contextUtil.handleSuccess(context)
        return
    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return    