# -*- coding: UTF-8 -*-

from cbb.business.operate.expansion import common
from cbb.business.operate.expansion.enclosure.v5HighEnd import fullBayFuncUtils
from cbb.frame.context import contextUtil


def execute(context):
    """V5高端整柜扩容初始化

    :param context:
    :return:
    """
    logger = common.getLogger(context.get("logger"), __file__)
    try:
        resultDict = {"flag": True, "errMsg": "", "suggestion": ""}
        lang = contextUtil.getLang(context)

        # 设置内部IP
        devObj = contextUtil.getDevObj(context)
        innerIps = devObj.get("devInnerIpList")
        contextUtil.setItem(context, "innerIps", innerIps)
        logger.logInfo("innerIps:%s" % innerIps)

        # 针对扩容后再次扩容场景,清除新硬盘柜数量和硬盘框标记
        fullBayFuncUtils.clear_context_item(context)

        # 检查工具与设备的连接
        isPass, errMsg = contextUtil.checkConnection(context)
        if not isPass:
            resultDict["flag"] = False
            resultDict["errMsg"], resultDict["suggestion"] = errMsg, ""
            contextUtil.handleFailure(context, resultDict)
            return

        tlv = contextUtil.getTlv(context)
        if tlv is None:
            logger.logNoPass("create tlv connection failure")
            resultDict["flag"] = False
            resultDict["errMsg"], resultDict["suggestion"] = \
                common.getMsg(lang, "dev.conn.failure")
            contextUtil.handleFailure(context, resultDict)
            return

        cli = contextUtil.getCli(context)
        # 针对V3R3C20以后版本的资料归一问题
        common.setSpecialMsgInfo(cli, lang, logger)

        # 获取设备信息
        isHandleSuccess, _ = common.getClsInfoForExpandDisk(context, tlv)
        if not isHandleSuccess:
            return

        fullBayFuncUtils.init_available_slots_num(context)
        common.initClsInfoForCabinets(context, tlv)
        # 上次扩容系统柜是否完成
        (isFinished, abnormalCtrls) = common.isExpandCtrlFinished(context)
        if not isFinished:
            logger.logNoPass("Expand controller is not finished")
            abnormalCtrlInfo = ",".join(abnormalCtrls)
            resultDict["flag"] = False
            resultDict["errMsg"], resultDict["suggestion"] = \
                common.getMsg(lang, "cluster.expand.ctrl.not.finished",
                              abnormalCtrlInfo)
            contextUtil.handleFailure(context, resultDict)
            return

        # 判断系统柜是否达到系统最大柜配置
        if not fullBayFuncUtils.check_max_config(context):
            logger.logNoPass("Max config of disk bay")
            resultDict["flag"] = False
            resultDict["errMsg"], resultDict["suggestion"] = \
                common.getMsg(lang, "cluster.max.diskBay.conf")
            contextUtil.handleFailure(context, resultDict)
            return

        # 根据扩容场景,设置扩容流程
        setStepFlow(context)

        contextUtil.handleSuccess(context)
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return


def setStepFlow(context):
    """根据扩容场景,设置扩容流程

    :param context:
    :return:
    """
    # 根据step ID设置界面向导中的步骤

    runStepIdList = []
    runStepIdList.append("notice")
    runStepIdList.append("preCheck")
    runStepIdList.append("selectConfig")
    runStepIdList.append("connectLine")
    runStepIdList.append("joinSystem")
    runStepIdList.append("confirmDiskEnc")
    runStepIdList.append("checkCables")
    runStepIdList.append("postCheck")
    runStepIdList.append("finished")

    context["runStepIdList"] = ",".join(runStepIdList)
    return
