# -*- coding: UTF-8 -*-

from cbb.business.operate.expansion import common
from cbb.business.operate.expansion import enclosureCommon
from cbb.frame.context import contextUtil
from cbb.frame.devGraph import graphUtil
from cbb.frame.tlv import tlvUtil
from cbb.business.operate.expansion import config


def initDevGraph(context):
    logger = common.getLogger(context.get("logger"), __file__)
    lang = contextUtil.getLang(context)
    
    logger.logInfo("draw devGraph")
    graphUtil.lightNewDiskEnclosures(context)
    
    productModel = contextUtil.getItem(context, "productModel")
    deepth = contextUtil.getItem(context, "deepth")

    if (deepth == '1' or deepth == '2') and (productModel.upper() in enclosureCommon.SERIES_18000F):
        # 18000F显示提示内容
        msg = common.getRes(lang, "connectLineMsg_deep1_refresh", (deepth, deepth))

    else:
        if deepth == "" or deepth == None:
            deepth = '4'
        u4Limit = int(deepth) / 2
        msg = common.getRes(lang, "connectLineMsg_deep_refresh", (deepth, deepth, str(u4Limit)))
    
    resultList = []
    errMsg = {"connectLine.message":msg}
    resultList.extend([errMsg])
    context["refreshData"] = common.dictList2JsonArray(resultList)

    # 通知升级模块硬盘框并发升级（在新扩硬盘框上电前通知）
    tlv = contextUtil.getTlv(context)
    newEnc2UList = contextUtil.getItem(context, "newEnc2UList")
    newEnc4UList = contextUtil.getItem(context, "newEnc4UList")
    logger.logInfo('newEnc2UList:' + str(newEnc2UList))
    logger.logInfo('newEnc4UList:' + str(newEnc4UList))
    newEncList = newEnc2UList + newEnc4UList
    tlvUtil.notifyEnclosureConcurrentUpgrade(tlv, len(newEncList), logger)
    
    #记录用户行为数据
    contextUtil.appendUserOpData(context, config.UserOpDataFields.EXPANSION_TYPE_ENCLOSURE)

    contextUtil.handleSuccess(context)
    logger.logPass()
    return

