# -*- coding: UTF-8 -*-

from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common

def initDevGraph(context):
    logger = common.getLogger(context.get("logger"), __file__)
    
    logger.logInfo("draw devGraph")
    productModel = contextUtil.getItem(context, "productModel")
    if common.isDorado18000(productModel):
        from cbb.frame.devGraph import dorodaoGraphUtil as graphUtil
    else:
        from cbb.frame.devGraph import graphUtil

    graphUtil.drawGraph(context, {"isBack":True})
    
    contextUtil.handleSuccess(context)
    logger.logPass()
    return