# -*- coding: UTF-8 -*-

from cbb.business.operate.expansion import common
from cbb.frame.context import contextUtil


def execute(context):
    logger = common.getLogger(context.get("logger"), __file__)

    logger.logInfo("light disk enclosure one by one")
    if contextUtil.getItem(context, 'isFullBayDeliverPdt', False):
        import cbb.frame.devGraph.dorodaoV6HighEndGraphUtil as graphUtil
        graphUtil.highLightNewDiskBayOrDae(context)
    else:
        import cbb.frame.devGraph.graphUtil as graphUtil
        graphUtil.lightDiskEnc(context)


    contextUtil.handleSuccess(context)
    logger.logPass()
    return