# -*- coding: UTF-8 -*-

from cbb.business.operate.expansion import common
from cbb.frame.context import contextUtil


def refreshData(context, param):
    """点击 2U硬盘框下拉框，并选择硬盘框个数时执行。

    :param context:
    :param param:
    :return:
    """
    logger = common.getLogger(context.get("logger"), __file__)
    try:

        changedId = context.get("input_changed_id")    # 当前触发的控件id
        logger.logInfo("input_changed_id: %s" % changedId)
        enclosureNum = int(context.get(changedId))  # 获取硬盘框的数量
        logger.logInfo("input 2U enclosure number: %d" % enclosureNum)

        contextUtil.setItem(context, "newEnc2UNum", enclosureNum)
        contextUtil.handleSuccess(context)
        return
    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
