# -*- coding: UTF-8 -*-

from cbb.frame.context import contextUtil
from cbb.frame.devGraph import graphUtil
from cbb.frame.devGraph import dorodaoGraphUtil
from cbb.business.operate.expansion import common
from cbb.business.operate.expansion import tableItemsUtil

COLUMN_NUMBER = 1  # 1列数据
COLUMN_NUMBER_FOR_DORADO = 3  # 3列数据


def initDevGraph(context):
    '''
    @summary: 初始化设备图
    '''
    logger = common.getLogger(context.get("logger"), __file__)
    # 绘制设备图
    devObj = contextUtil.getDevObj(context)
    productModel = devObj.get("type")
    if common.isDorado18000(productModel):
        dorodaoGraphUtil.drawGraph(context, {"isBack": False})
    else:
        graphUtil.drawGraph(context, {"isBack": False})

    logger.logInfo("initial devices graph succes")
    contextUtil.handleSuccess(context)
    return


def init(context):
    '''
    @summary: 初始化界面配置数据，初始化时列表中只显示一行数据，需要多行数据可以使用界面”添加“按钮
    '''
    tableItems = []
    logger = common.getLogger(context.get("logger"), __file__)

    # 表头配置数据
    tableHeadItem = tableItemsUtil.getTableRowItem(context, COLUMN_NUMBER)
    tableItems.append(tableHeadItem)

    # 第一行数据
    rowId = 1
    contextUtil.setItem(context, "curRow", rowId)  # 记录当前行数，作为记录每行数据key
    firstColItem = tableItemsUtil.getTableRowItem(context, COLUMN_NUMBER, rowId)
    tableItems.append(firstColItem)
    logger.logInfo("tableItems:%s" % str(tableItems))

    # 设置初始化项目
    ret = contextUtil.setTableItemInit(context, tableItems)
    logger.logInfo("retData_init:")
    context.get("logger").info("retData_init:%s" % ret)
    contextUtil.handleSuccess(context)
    return


def saveData(context):
    '''
    @summary: 保存配置数据：暂时未用
    '''
    contextUtil.handleSuccess(context)
    return


def verifyData(context):
    '''
    @summary: 验证配置数据：点击”下一步“，则会调用该方法
    '''
    logger = common.getLogger(context.get("logger"), __file__)
    newEnc2UNum = contextUtil.getItem(context, "newEnc2UNum", 0)
    if newEnc2UNum == 0:
        logger.logInfo("new enclosure number: %s, verifyData result: False" %
                       newEnc2UNum)
        context["verifySucc"] = False
        return

    context["verifySucc"] = True
    return


def verifyFailed(context):
    '''
    @summary: 标记已验证失败的数据行
    '''
    logger = common.getLogger(context.get("logger"), __file__)
    lang = contextUtil.getLang(context)

    dialogUtil = context.get("dialogUtil")
    # 无配置信息
    context["failItems"] = ""
    errMsg = common.getRes(lang, "donot_add_enclosure_config")
    nextProc = dialogUtil.showInfoDialog(errMsg)
    context["nextProc"] = nextProc
    return
