# -*- coding: UTF-8 -*-

from cbb.business.operate.expansion import common
from cbb.frame.context import contextUtil
from cbb.frame.devGraph import dorodaoGraphUtil as graphUtil
from cbb.business.operate.expansion import jsonUtil
from cbb.business.operate.expansion import tableItemsUtil


def refreshData(context, param):
    """刷新归属控制器的数据

    :param context:
    :param param:
    :return:
    """
    logger = common.getLogger(context.get("logger"), __file__)
    try:
        changedId = context.get("input_changed_id")  # 当前触发的控件id
        logger.logInfo("input_changed_id: %s" % changedId)
        itemIds = changedId.split("_")  # 上下文获取到的格式为stepId_rowId_colId
        rowId = itemIds[1]

        inputOwningCtrl = context.get(changedId)  # 获取归属控制器
        logger.logInfo("input owning ctrl name: %s" % inputOwningCtrl)

        # 判断该归属控制器是否已经完成配置
        isConfigured = common.checkOwningCtrlConfigured(context, rowId, inputOwningCtrl)
        logger.logInfo("check same owing ctrl result:%s" % str(isConfigured))
        if isConfigured:
            executeOwingCtrlConfigured(context, inputOwningCtrl, changedId)
            contextUtil.handleSuccess(context)
            return
        else:
            executeConfiguringNewOwnintCtrl(context, inputOwningCtrl, changedId)

        contextUtil.updateSelectedConfig(context, rowId, "owningCtrl", inputOwningCtrl)
        contextUtil.updateOwningCtrlInfoInContext(context)

        # 更新设备图
        if contextUtil.getItem(context, 'isDorado18000', False):
            contextUtil.updateNewBayListForDorado18000(context)
            graphUtil.refreshGraph(context, 'BAY', False)

            encGraphInfoList = common.createEncGraphInfo(context)
            logger.logInfo("encGraphInfoList:%s" % str(encGraphInfoList))

            contextUtil.setItem(context, "encGraphInfoList", encGraphInfoList)
            graphUtil.refreshGraph(context, 'EXP', False)

        contextUtil.handleSuccess(context)
        return
    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return


def executeOwingCtrlConfigured(context, inputOwningCtrl, changedId):
    """归属控制器已经配置时提示.

    :param context:
    :param inputOwningCtrl:
    :param changedId:
    :return:
    """
    logger = common.getLogger(context.get("logger"), __file__)
    lang = contextUtil.getLang(context)
    logger.logInfo("owning ctrl already configured")

    # 弹出提示框
    dialogUtil = context.get("dialogUtil")
    errMsg = common.getRes(lang, "exist_same_owning_ctrl")
    nextProc = dialogUtil.showInfoDialog(errMsg)
    context["nextProc"] = nextProc
    context["remind"] = True
    context["isRefresh"] = False  # 是否需要刷新为当前值
    return


def executeConfiguringNewOwnintCtrl(context, inputOwningCtrl, changedId):
    """选择新的的归属控制器时联动处理.

    :param context:
    :param inputOwningCtrl:
    :param changedId:
    :return:
    """

    logger = common.getLogger(context.get("logger"), __file__)
    logger.logInfo("select new owing controller")

    itemIds = changedId.split("_")  # 上下文获取到的格式为stepId_rowId_colId
    colId = itemIds[-1]

    # 联动2U硬盘框
    refresh2UColId = int(colId) + 1
    refresh2UItemKey = 'return_%d' % refresh2UColId
    newRule = tableItemsUtil.getEnclosureRuleForDorado18000(context, inputOwningCtrl)
    logger.logInfo("the new rule for 2U enclosure: %s" % newRule)
    newItem = {
        "rule": newRule,
        "default": "0"
    }

    refresh2UValue = jsonUtil.dict2JsonStr(newItem)
    context[refresh2UItemKey] = refresh2UValue

    return
